/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.util.List;
import org.antlr.v4.runtime.tree.ParseTree;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.repository.query.DtoProjectionTransformerDelegate;
import org.springframework.data.jpa.repository.query.HibernateQueryInformation;
import org.springframework.data.jpa.repository.query.HqlParser;
import org.springframework.data.jpa.repository.query.HqlQueryRenderer;
import org.springframework.data.jpa.repository.query.JpaQueryTransformerSupport;
import org.springframework.data.jpa.repository.query.QueryRenderer;
import org.springframework.data.jpa.repository.query.QueryToken;
import org.springframework.data.jpa.repository.query.QueryTokenStream;
import org.springframework.data.jpa.repository.query.QueryTokens;
import org.springframework.data.repository.query.ReturnedType;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

class HqlSortedQueryTransformer
extends HqlQueryRenderer {
    private final JpaQueryTransformerSupport transformerSupport = new JpaQueryTransformerSupport();
    private final Sort sort;
    @Nullable
    private final String primaryFromAlias;
    @Nullable
    private final DtoProjectionTransformerDelegate dtoDelegate;

    HqlSortedQueryTransformer(Sort sort, HibernateQueryInformation queryInformation, @Nullable ReturnedType returnedType) {
        Assert.notNull((Object)sort, (String)"Sort must not be null");
        Assert.notNull((Object)queryInformation, (String)"ParsedHqlQueryInformation must not be null");
        this.sort = sort;
        this.primaryFromAlias = queryInformation.getAlias();
        this.dtoDelegate = returnedType == null ? null : new DtoProjectionTransformerDelegate(returnedType);
    }

    @Override
    public QueryTokenStream visitQueryExpression(HqlParser.QueryExpressionContext ctx) {
        if (ObjectUtils.isEmpty(ctx.setOperator())) {
            return super.visitQueryExpression(ctx);
        }
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.withClause() != null) {
            builder.appendExpression((QueryTokenStream)this.visit((ParseTree)ctx.withClause()));
        }
        List<HqlParser.OrderedQueryContext> orderedQueries = ctx.orderedQuery();
        int i = 0;
        while (i < orderedQueries.size()) {
            if (i != 0) {
                builder.append((QueryTokenStream)this.visit((ParseTree)ctx.setOperator(i - 1)));
            }
            if (i == orderedQueries.size() - 1) {
                builder.append(this.visitOrderedQuery(ctx.orderedQuery(i), this.sort));
            } else {
                builder.append(this.visitOrderedQuery(ctx.orderedQuery(i), Sort.unsorted()));
            }
            ++i;
        }
        return builder;
    }

    @Override
    public QueryRenderer.QueryRendererBuilder visitOrderedQuery(HqlParser.OrderedQueryContext ctx) {
        return this.visitOrderedQuery(ctx, this.sort);
    }

    @Override
    public QueryTokenStream visitSelectionList(HqlParser.SelectionListContext ctx) {
        QueryTokenStream tokenStream = super.visitSelectionList(ctx);
        if (this.dtoDelegate != null && !HqlSortedQueryTransformer.isSubquery(ctx)) {
            return this.dtoDelegate.transformSelectionList(tokenStream);
        }
        return tokenStream;
    }

    @Override
    public QueryTokenStream visitJoinPath(HqlParser.JoinPathContext ctx) {
        QueryTokenStream tokens = super.visitJoinPath(ctx);
        if (ctx.variable() != null && !HqlSortedQueryTransformer.isSubquery(ctx)) {
            this.transformerSupport.registerAlias(tokens.getRequiredLast());
        }
        return tokens;
    }

    @Override
    public QueryTokenStream visitJoinSubquery(HqlParser.JoinSubqueryContext ctx) {
        QueryTokenStream tokens = super.visitJoinSubquery(ctx);
        if (ctx.variable() != null && !tokens.isEmpty() && !HqlSortedQueryTransformer.isSubquery(ctx)) {
            this.transformerSupport.registerAlias(tokens.getRequiredLast());
        }
        return tokens;
    }

    @Override
    public QueryTokenStream visitVariable(HqlParser.VariableContext ctx) {
        QueryTokenStream tokens = super.visitVariable(ctx);
        if (ctx.identifier() != null && !tokens.isEmpty() && !HqlSortedQueryTransformer.isSubquery(ctx)) {
            this.transformerSupport.registerAlias(tokens.getRequiredLast());
        }
        return tokens;
    }

    private QueryRenderer.QueryRendererBuilder visitOrderedQuery(HqlParser.OrderedQueryContext ctx, Sort sort) {
        QueryRenderer.QueryRendererBuilder builder = QueryRenderer.builder();
        if (ctx.query() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.query()));
        } else if (ctx.queryExpression() != null) {
            builder.append(QueryTokens.TOKEN_OPEN_PAREN);
            builder.appendInline((QueryTokenStream)this.visit((ParseTree)ctx.queryExpression()));
            builder.append(QueryTokens.TOKEN_CLOSE_PAREN);
        }
        if (!HqlSortedQueryTransformer.isSubquery(ctx)) {
            if (ctx.queryOrder() != null) {
                QueryTokenStream existingOrder = (QueryTokenStream)this.visit((ParseTree)ctx.queryOrder());
                if (sort.isSorted()) {
                    builder.appendInline(existingOrder);
                } else {
                    builder.append(existingOrder);
                }
            }
            if (sort.isSorted()) {
                List<QueryToken> sortBy = this.transformerSupport.orderBy(this.primaryFromAlias, sort);
                if (ctx.queryOrder() != null) {
                    QueryRenderer.QueryRendererBuilder extension = QueryRenderer.builder().append(QueryTokens.TOKEN_COMMA).append(sortBy);
                    builder.appendInline(extension);
                } else {
                    builder.append(QueryTokens.TOKEN_ORDER_BY);
                    builder.append(sortBy);
                }
            }
        } else if (ctx.queryOrder() != null) {
            builder.append((QueryTokenStream)this.visit((ParseTree)ctx.queryOrder()));
        }
        return builder;
    }
}

