/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.domain;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.io.Serializable;
import org.springframework.data.jpa.domain.DeleteSpecification;
import org.springframework.data.jpa.domain.PredicateSpecification;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.domain.UpdateSpecification;
import org.springframework.lang.Nullable;

class SpecificationComposition {
    SpecificationComposition() {
    }

    static <T> Specification<T> composed(@Nullable Specification<T> lhs, @Nullable Specification<T> rhs, Combiner combiner) {
        return (root, query, builder) -> {
            Predicate thisPredicate = SpecificationComposition.toPredicate(lhs, root, query, builder);
            Predicate otherPredicate = SpecificationComposition.toPredicate(rhs, root, query, builder);
            if (thisPredicate == null) {
                return otherPredicate;
            }
            return otherPredicate == null ? thisPredicate : combiner.combine(builder, thisPredicate, otherPredicate);
        };
    }

    @Nullable
    private static <T> Predicate toPredicate(@Nullable Specification<T> specification, Root<T> root, @Nullable CriteriaQuery<?> query, CriteriaBuilder builder) {
        return specification == null ? null : specification.toPredicate(root, query, builder);
    }

    static <T> DeleteSpecification<T> composed(@Nullable DeleteSpecification<T> lhs, @Nullable DeleteSpecification<T> rhs, Combiner combiner) {
        return (root, query, builder) -> {
            Predicate thisPredicate = SpecificationComposition.toPredicate(lhs, root, query, builder);
            Predicate otherPredicate = SpecificationComposition.toPredicate(rhs, root, query, builder);
            if (thisPredicate == null) {
                return otherPredicate;
            }
            return otherPredicate == null ? thisPredicate : combiner.combine(builder, thisPredicate, otherPredicate);
        };
    }

    @Nullable
    private static <T> Predicate toPredicate(@Nullable DeleteSpecification<T> specification, Root<T> root, @Nullable CriteriaDelete<T> delete, CriteriaBuilder builder) {
        return specification == null ? null : specification.toPredicate(root, delete, builder);
    }

    static <T> UpdateSpecification<T> composed(@Nullable UpdateSpecification<T> lhs, @Nullable UpdateSpecification<T> rhs, Combiner combiner) {
        return (root, query, builder) -> {
            Predicate thisPredicate = SpecificationComposition.toPredicate(lhs, root, query, builder);
            Predicate otherPredicate = SpecificationComposition.toPredicate(rhs, root, query, builder);
            if (thisPredicate == null) {
                return otherPredicate;
            }
            return otherPredicate == null ? thisPredicate : combiner.combine(builder, thisPredicate, otherPredicate);
        };
    }

    @Nullable
    private static <T> Predicate toPredicate(@Nullable UpdateSpecification<T> specification, Root<T> root, CriteriaUpdate<T> update, CriteriaBuilder builder) {
        return specification == null ? null : specification.toPredicate(root, update, builder);
    }

    static <T> PredicateSpecification<T> composed(PredicateSpecification<T> lhs, PredicateSpecification<T> rhs, Combiner combiner) {
        return (root, builder) -> {
            Predicate thisPredicate = SpecificationComposition.toPredicate(lhs, root, builder);
            Predicate otherPredicate = SpecificationComposition.toPredicate(rhs, root, builder);
            if (thisPredicate == null) {
                return otherPredicate;
            }
            return otherPredicate == null ? thisPredicate : combiner.combine(builder, thisPredicate, otherPredicate);
        };
    }

    @Nullable
    private static <T> Predicate toPredicate(@Nullable PredicateSpecification<T> specification, Root<T> root, CriteriaBuilder builder) {
        return specification == null ? null : specification.toPredicate(root, builder);
    }

    static interface Combiner
    extends Serializable {
        public Predicate combine(CriteriaBuilder var1, @Nullable Predicate var2, @Nullable Predicate var3);
    }
}

