/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.domain;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import java.io.Serializable;
import java.util.Arrays;
import java.util.stream.StreamSupport;
import org.springframework.data.jpa.domain.SpecificationComposition;
import org.springframework.lang.CheckReturnValue;
import org.springframework.lang.Contract;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public interface PredicateSpecification<T>
extends Serializable {
    public static <T> PredicateSpecification<T> unrestricted() {
        return (root, builder) -> null;
    }

    public static <T> PredicateSpecification<T> where(PredicateSpecification<T> spec) {
        Assert.notNull(spec, (String)"PredicateSpecification must not be null");
        return spec;
    }

    @Contract(value="_ -> new")
    @CheckReturnValue
    default public PredicateSpecification<T> and(PredicateSpecification<T> other) {
        Assert.notNull(other, (String)"Other specification must not be null");
        return SpecificationComposition.composed(this, other, CriteriaBuilder::and);
    }

    @Contract(value="_ -> new")
    @CheckReturnValue
    default public PredicateSpecification<T> or(PredicateSpecification<T> other) {
        Assert.notNull(other, (String)"Other specification must not be null");
        return SpecificationComposition.composed(this, other, CriteriaBuilder::or);
    }

    public static <T> PredicateSpecification<T> not(PredicateSpecification<T> spec) {
        Assert.notNull(spec, (String)"Specification must not be null");
        return (root, builder) -> {
            Predicate predicate = spec.toPredicate(root, builder);
            return predicate != null ? builder.not((Expression)predicate) : null;
        };
    }

    @SafeVarargs
    public static <T> PredicateSpecification<T> allOf(PredicateSpecification<T> ... specifications) {
        return PredicateSpecification.allOf(Arrays.asList(specifications));
    }

    public static <T> PredicateSpecification<T> allOf(Iterable<PredicateSpecification<T>> specifications) {
        return StreamSupport.stream(specifications.spliterator(), false).reduce(PredicateSpecification.unrestricted(), PredicateSpecification::and);
    }

    @SafeVarargs
    public static <T> PredicateSpecification<T> anyOf(PredicateSpecification<T> ... specifications) {
        return PredicateSpecification.anyOf(Arrays.asList(specifications));
    }

    public static <T> PredicateSpecification<T> anyOf(Iterable<PredicateSpecification<T>> specifications) {
        return StreamSupport.stream(specifications.spliterator(), false).reduce(PredicateSpecification.unrestricted(), PredicateSpecification::or);
    }

    @Nullable
    public Predicate toPredicate(Root<T> var1, CriteriaBuilder var2);
}

