/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jdbc.core.convert;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.springframework.data.jdbc.core.convert.BatchInsertStrategy;
import org.springframework.data.jdbc.core.convert.InsertStrategy;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.dialect.IdGeneration;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.lang.Nullable;

class IdGeneratingBatchInsertStrategy
implements BatchInsertStrategy {
    private final InsertStrategy insertStrategy;
    private final Dialect dialect;
    private final NamedParameterJdbcOperations jdbcOperations;
    private final SqlIdentifier idColumn;

    IdGeneratingBatchInsertStrategy(InsertStrategy insertStrategy, Dialect dialect, NamedParameterJdbcOperations jdbcOperations, @Nullable SqlIdentifier idColumn) {
        this.insertStrategy = insertStrategy;
        this.dialect = dialect;
        this.jdbcOperations = jdbcOperations;
        this.idColumn = idColumn;
    }

    @Override
    public Object[] execute(String sql, SqlParameterSource[] sqlParameterSources) {
        if (!this.dialect.getIdGeneration().supportedForBatchOperations()) {
            return Arrays.stream(sqlParameterSources).map(sqlParameterSource -> this.insertStrategy.execute(sql, (SqlParameterSource)sqlParameterSource)).toArray();
        }
        GeneratedKeyHolder holder = new GeneratedKeyHolder();
        IdGeneration idGeneration = this.dialect.getIdGeneration();
        if (idGeneration.driverRequiresKeyColumnNames()) {
            String[] keyColumnNames = this.getKeyColumnNames();
            if (keyColumnNames.length == 0) {
                this.jdbcOperations.batchUpdate(sql, sqlParameterSources, (KeyHolder)holder);
            } else {
                this.jdbcOperations.batchUpdate(sql, sqlParameterSources, (KeyHolder)holder, keyColumnNames);
            }
        } else {
            this.jdbcOperations.batchUpdate(sql, sqlParameterSources, (KeyHolder)holder);
        }
        Object[] ids = new Object[sqlParameterSources.length];
        List keyList = holder.getKeyList();
        for (int i = 0; i < keyList.size(); ++i) {
            Map keys = (Map)keyList.get(i);
            if (keys.size() > 1) {
                if (this.idColumn == null) continue;
                ids[i] = keys.get(this.idColumn.getReference());
                continue;
            }
            ids[i] = keys.entrySet().stream().findFirst().map(Map.Entry::getValue).orElseThrow(() -> new IllegalStateException("KeyHolder contains an empty key list"));
        }
        return ids;
    }

    /*
     * Exception decompiling
     */
    private String[] getKeyColumnNames() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

