/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.config.annotation.support;

import java.util.Optional;
import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.gemfire.GemfireUtils;
import org.springframework.data.gemfire.config.annotation.support.AbstractAuthInitialize;
import org.springframework.data.gemfire.config.annotation.support.Authentication;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class AutoConfiguredAuthenticationInitializer
extends AbstractAuthInitialize {
    public static final String SECURITY_USERNAME_PROPERTY = "security-username";
    public static final String SECURITY_PASSWORD_PROPERTY = "security-password";
    protected static final Properties NO_PARAMETERS = new Properties();
    private Authentication<String, String> authentication;

    public static AutoConfiguredAuthenticationInitializer newAuthenticationInitializer() {
        AutoConfiguredAuthenticationInitializer authenticationInitializer = new AutoConfiguredAuthenticationInitializer();
        authenticationInitializer.initialize(GemfireUtils.getCache(), NO_PARAMETERS);
        return authenticationInitializer;
    }

    @Autowired(required=false)
    public void setAuthentication(@Nullable Authentication<String, String> authentication) {
        this.authentication = authentication;
    }

    protected Optional<Authentication<String, String>> getAuthentication() {
        return Optional.ofNullable(this.authentication);
    }

    @Override
    @NonNull
    protected Properties doGetCredentials(@NonNull Properties properties) {
        this.getAuthentication().filter(Authentication::isRequested).ifPresent(authentication -> {
            properties.setProperty(SECURITY_USERNAME_PROPERTY, (String)authentication.getPrincipal());
            properties.setProperty(SECURITY_PASSWORD_PROPERTY, (String)authentication.getCredentials());
        });
        return properties;
    }
}

