/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.gemfire.wan;

import java.util.List;
import java.util.Optional;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.asyncqueue.AsyncEventListener;
import org.apache.geode.cache.asyncqueue.AsyncEventQueue;
import org.apache.geode.cache.asyncqueue.AsyncEventQueueFactory;
import org.apache.geode.cache.wan.GatewayEventFilter;
import org.apache.geode.cache.wan.GatewayEventSubstitutionFilter;
import org.apache.geode.cache.wan.GatewaySender;
import org.springframework.data.gemfire.util.CollectionUtils;
import org.springframework.data.gemfire.util.SpringExtensions;
import org.springframework.data.gemfire.wan.AbstractWANComponentFactoryBean;
import org.springframework.util.Assert;

public class AsyncEventQueueFactoryBean
extends AbstractWANComponentFactoryBean<AsyncEventQueue> {
    private AsyncEventListener asyncEventListener;
    private AsyncEventQueue asyncEventQueue;
    private Boolean batchConflationEnabled;
    private Boolean diskSynchronous;
    private Boolean forwardExpirationDestroy;
    private Boolean parallel;
    private Boolean persistent;
    private Boolean pauseEventDispatching;
    private Integer batchSize;
    private Integer batchTimeInterval;
    private Integer dispatcherThreads;
    private Integer maximumQueueMemory;
    private GatewayEventSubstitutionFilter gatewayEventSubstitutionFilter;
    private GatewaySender.OrderPolicy orderPolicy;
    private List<GatewayEventFilter> gatewayEventFilters;
    private String diskStoreReference;

    public AsyncEventQueueFactoryBean(Cache cache) {
        this(cache, null);
    }

    public AsyncEventQueueFactoryBean(Cache cache, AsyncEventListener asyncEventListener) {
        super((GemFireCache)cache);
        this.setAsyncEventListener(asyncEventListener);
    }

    public AsyncEventQueue getObject() throws Exception {
        return this.asyncEventQueue;
    }

    public Class<?> getObjectType() {
        return this.asyncEventQueue != null ? this.asyncEventQueue.getClass() : AsyncEventQueue.class;
    }

    @Override
    protected void doInit() {
        AsyncEventListener listener = this.getAsyncEventListener();
        Assert.state((listener != null ? 1 : 0) != 0, (String)"AsyncEventListener must not be null");
        AsyncEventQueueFactory asyncEventQueueFactory = this.resolveAsyncEventQueueFactory();
        Optional.ofNullable(this.batchConflationEnabled).ifPresent(arg_0 -> ((AsyncEventQueueFactory)asyncEventQueueFactory).setBatchConflationEnabled(arg_0));
        Optional.ofNullable(this.batchSize).ifPresent(arg_0 -> ((AsyncEventQueueFactory)asyncEventQueueFactory).setBatchSize(arg_0));
        Optional.ofNullable(this.batchTimeInterval).ifPresent(arg_0 -> ((AsyncEventQueueFactory)asyncEventQueueFactory).setBatchTimeInterval(arg_0));
        Optional.ofNullable(this.diskStoreReference).ifPresent(arg_0 -> ((AsyncEventQueueFactory)asyncEventQueueFactory).setDiskStoreName(arg_0));
        Optional.ofNullable(this.diskSynchronous).ifPresent(arg_0 -> ((AsyncEventQueueFactory)asyncEventQueueFactory).setDiskSynchronous(arg_0));
        Optional.ofNullable(this.dispatcherThreads).ifPresent(arg_0 -> ((AsyncEventQueueFactory)asyncEventQueueFactory).setDispatcherThreads(arg_0));
        Optional.ofNullable(this.forwardExpirationDestroy).ifPresent(arg_0 -> ((AsyncEventQueueFactory)asyncEventQueueFactory).setForwardExpirationDestroy(arg_0));
        Optional.ofNullable(this.gatewayEventSubstitutionFilter).ifPresent(arg_0 -> ((AsyncEventQueueFactory)asyncEventQueueFactory).setGatewayEventSubstitutionListener(arg_0));
        Optional.ofNullable(this.maximumQueueMemory).ifPresent(arg_0 -> ((AsyncEventQueueFactory)asyncEventQueueFactory).setMaximumQueueMemory(arg_0));
        Optional.ofNullable(this.persistent).ifPresent(arg_0 -> ((AsyncEventQueueFactory)asyncEventQueueFactory).setPersistent(arg_0));
        if (this.isPauseEventDispatching()) {
            asyncEventQueueFactory.pauseEventDispatching();
        }
        asyncEventQueueFactory.setParallel(this.isParallelEventQueue());
        if (this.orderPolicy != null) {
            Assert.state((boolean)this.isSerialEventQueue(), (String)"OrderPolicy cannot be used with a Parallel AsyncEventQueue");
            asyncEventQueueFactory.setOrderPolicy(this.orderPolicy);
        }
        CollectionUtils.nullSafeList(this.gatewayEventFilters).forEach(arg_0 -> ((AsyncEventQueueFactory)asyncEventQueueFactory).addGatewayEventFilter(arg_0));
        this.setAsyncEventQueue(asyncEventQueueFactory.create(this.getName(), listener));
    }

    private AsyncEventQueueFactory resolveAsyncEventQueueFactory() {
        return this.factory != null ? (AsyncEventQueueFactory)this.factory : this.cache.createAsyncEventQueueFactory();
    }

    @Override
    public void destroy() {
        if (!this.getCache().isClosed()) {
            SpringExtensions.safeDoOperation(() -> this.asyncEventListener.close());
        }
    }

    public final void setAsyncEventListener(AsyncEventListener listener) {
        Assert.state((this.asyncEventQueue == null ? 1 : 0) != 0, (String)"Setting an AsyncEventListener is not allowed once the AsyncEventQueue has been created");
        this.asyncEventListener = listener;
    }

    public AsyncEventListener getAsyncEventListener() {
        return this.asyncEventListener;
    }

    public void setAsyncEventQueue(AsyncEventQueue asyncEventQueue) {
        this.asyncEventQueue = asyncEventQueue;
    }

    public AsyncEventQueue getAsyncEventQueue() {
        return this.asyncEventQueue;
    }

    public void setBatchConflationEnabled(Boolean batchConflationEnabled) {
        this.batchConflationEnabled = batchConflationEnabled;
    }

    public void setBatchSize(Integer batchSize) {
        this.batchSize = batchSize;
    }

    public void setBatchTimeInterval(Integer batchTimeInterval) {
        this.batchTimeInterval = batchTimeInterval;
    }

    public void setDiskStoreRef(String diskStoreRef) {
        this.diskStoreReference = diskStoreRef;
    }

    public void setDiskSynchronous(Boolean diskSynchronous) {
        this.diskSynchronous = diskSynchronous;
    }

    public void setDispatcherThreads(Integer dispatcherThreads) {
        this.dispatcherThreads = dispatcherThreads;
    }

    public void setForwardExpirationDestroy(Boolean forwardExpirationDestroy) {
        this.forwardExpirationDestroy = forwardExpirationDestroy;
    }

    public void setGatewayEventFilters(List<GatewayEventFilter> eventFilters) {
        this.gatewayEventFilters = eventFilters;
    }

    public void setGatewayEventSubstitutionFilter(GatewayEventSubstitutionFilter eventSubstitutionFilter) {
        this.gatewayEventSubstitutionFilter = eventSubstitutionFilter;
    }

    public void setMaximumQueueMemory(Integer maximumQueueMemory) {
        this.maximumQueueMemory = maximumQueueMemory;
    }

    public void setOrderPolicy(String orderPolicy) {
        this.setOrderPolicy(GatewaySender.OrderPolicy.valueOf((String)String.valueOf(orderPolicy).toUpperCase()));
    }

    public void setOrderPolicy(GatewaySender.OrderPolicy orderPolicy) {
        this.orderPolicy = orderPolicy;
    }

    public void setParallel(Boolean parallel) {
        this.parallel = parallel;
    }

    public boolean isParallelEventQueue() {
        return Boolean.TRUE.equals(this.parallel);
    }

    public void setPauseEventDispatching(Boolean pauseEventDispatching) {
        this.pauseEventDispatching = pauseEventDispatching;
    }

    public boolean isPauseEventDispatching() {
        return Boolean.TRUE.equals(this.pauseEventDispatching);
    }

    public void setPersistent(Boolean persistent) {
        this.persistent = persistent;
    }

    public boolean isSerialEventQueue() {
        return !this.isParallelEventQueue();
    }
}

