/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.elasticsearch.client.elc;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.core.search.HitsMetadata;
import co.elastic.clients.elasticsearch.core.search.ResponseBody;
import co.elastic.clients.elasticsearch.core.search.Suggestion;
import co.elastic.clients.elasticsearch.core.search.TotalHits;
import co.elastic.clients.json.JsonpMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.data.elasticsearch.client.elc.DocumentAdapters;
import org.springframework.data.elasticsearch.client.elc.ElasticsearchAggregations;
import org.springframework.data.elasticsearch.client.elc.EntityAsMap;
import org.springframework.data.elasticsearch.core.TotalHitsRelation;
import org.springframework.data.elasticsearch.core.document.SearchDocument;
import org.springframework.data.elasticsearch.core.document.SearchDocumentResponse;
import org.springframework.data.elasticsearch.core.suggest.response.Suggest;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

class SearchDocumentResponseBuilder {
    SearchDocumentResponseBuilder() {
    }

    public static <T> SearchDocumentResponse from(ResponseBody<EntityAsMap> responseBody, SearchDocumentResponse.EntityCreator<T> entityCreator, JsonpMapper jsonpMapper) {
        Assert.notNull(responseBody, (String)"responseBody must not be null");
        Assert.notNull(entityCreator, (String)"entityCreator must not be null");
        HitsMetadata hitsMetadata = responseBody.hits();
        String scrollId = responseBody.scrollId();
        Map aggregations = responseBody.aggregations();
        Map suggest = responseBody.suggest();
        return SearchDocumentResponseBuilder.from(hitsMetadata, scrollId, aggregations, suggest, entityCreator, jsonpMapper);
    }

    public static <T> SearchDocumentResponse from(HitsMetadata<?> hitsMetadata, @Nullable String scrollId, Map<String, Aggregate> aggregations, Map<String, List<Suggestion<EntityAsMap>>> suggestES, SearchDocumentResponse.EntityCreator<T> entityCreator, JsonpMapper jsonpMapper) {
        String totalHitsRelation;
        long totalHits;
        Assert.notNull(hitsMetadata, (String)"hitsMetadata must not be null");
        TotalHits responseTotalHits = hitsMetadata.total();
        if (responseTotalHits != null) {
            totalHits = responseTotalHits.value();
            switch (responseTotalHits.relation().jsonValue()) {
                case "eq": {
                    totalHitsRelation = TotalHitsRelation.EQUAL_TO.name();
                    break;
                }
                case "gte": {
                    totalHitsRelation = TotalHitsRelation.GREATER_THAN_OR_EQUAL_TO.name();
                    break;
                }
                default: {
                    totalHitsRelation = TotalHitsRelation.OFF.name();
                    break;
                }
            }
        } else {
            totalHits = hitsMetadata.hits().size();
            totalHitsRelation = "OFF";
        }
        float maxScore = hitsMetadata.maxScore() != null ? hitsMetadata.maxScore().floatValue() : Float.NaN;
        ArrayList<SearchDocument> searchDocuments = new ArrayList<SearchDocument>();
        for (Hit hit : hitsMetadata.hits()) {
            searchDocuments.add(DocumentAdapters.from(hit, jsonpMapper));
        }
        ElasticsearchAggregations aggregationsContainer = aggregations != null ? new ElasticsearchAggregations(aggregations) : null;
        Suggest suggest = null;
        return new SearchDocumentResponse(totalHits, totalHitsRelation, maxScore, scrollId, searchDocuments, aggregationsContainer, suggest);
    }
}

