/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.couchbase.repository.query;

import org.jspecify.annotations.Nullable;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.couchbase.core.CouchbaseOperations;
import org.springframework.data.couchbase.core.ExecutableFindByQueryOperation;
import org.springframework.data.couchbase.core.ExecutableRemoveByQueryOperation;
import org.springframework.data.couchbase.core.query.Query;
import org.springframework.data.couchbase.repository.query.AbstractCouchbaseQueryBase;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryExecution;
import org.springframework.data.couchbase.repository.query.CouchbaseQueryMethod;
import org.springframework.data.couchbase.repository.query.ResultProcessingConverter;
import org.springframework.data.repository.core.EntityMetadata;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ResultProcessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.util.Assert;

public abstract class AbstractCouchbaseQuery
extends AbstractCouchbaseQueryBase<CouchbaseOperations>
implements RepositoryQuery {
    private final ExecutableFindByQueryOperation.ExecutableFindByQuery<?> findOp;
    private final ExecutableRemoveByQueryOperation.ExecutableRemoveByQuery<?> removeOp;

    public AbstractCouchbaseQuery(CouchbaseQueryMethod method, CouchbaseOperations operations, SpelExpressionParser expressionParser, QueryMethodEvaluationContextProvider evaluationContextProvider) {
        super(method, operations, expressionParser, evaluationContextProvider);
        Assert.notNull((Object)((Object)method), (String)"CouchbaseQueryMethod must not be null!");
        Assert.notNull((Object)operations, (String)"ReactiveCouchbaseOperations must not be null!");
        Assert.notNull((Object)expressionParser, (String)"SpelExpressionParser must not be null!");
        Assert.notNull((Object)evaluationContextProvider, (String)"QueryMethodEvaluationContextProvider must not be null!");
        EntityMetadata metadata = method.getEntityInformation();
        Class type = metadata.getJavaType();
        this.findOp = (ExecutableFindByQueryOperation.ExecutableFindByQuery)operations.findByQuery(type).inScope(method.getScope()).inCollection(method.getCollection());
        this.removeOp = (ExecutableRemoveByQueryOperation.ExecutableRemoveByQuery)operations.removeByQuery(type).inScope(method.getScope()).inCollection(method.getCollection());
    }

    @Override
    protected Object doExecute(CouchbaseQueryMethod method, ResultProcessor processor, ParametersParameterAccessor accessor, @Nullable Class<?> typeToRead) {
        Query query = this.createQuery(accessor);
        query = this.applyQueryMetaAttributesIfPresent(query, typeToRead);
        CouchbaseQueryExecution execution = this.getExecution((ParameterAccessor)accessor, new ResultProcessingConverter<CouchbaseOperations>(processor, (CouchbaseOperations)this.getOperations(), this.getInstantiators()), this.findOp);
        return execution.execute(query, processor.getReturnedType().getDomainType(), typeToRead, method.getScope(), method.getCollection());
    }

    private CouchbaseQueryExecution getExecution(ParameterAccessor accessor, Converter<Object, Object> resultProcessing, ExecutableFindByQueryOperation.ExecutableFindByQuery<?> operation) {
        return new CouchbaseQueryExecution.ResultProcessingExecution(this.getExecutionToWrap(accessor, operation), resultProcessing);
    }

    private CouchbaseQueryExecution getExecutionToWrap(ParameterAccessor accessor, ExecutableFindByQueryOperation.ExecutableFindByQuery<?> findOp) {
        if (this.isDeleteQuery()) {
            return new CouchbaseQueryExecution.DeleteExecution(this.removeOp);
        }
        if (this.isTailable(this.getQueryMethod())) {
            return (q, t, r, s, c) -> findOp.as(r).inScope(s).inCollection(c).matching(q.with(accessor.getPageable())).all();
        }
        if (this.getQueryMethod().isCollectionQuery()) {
            return (q, t, r, s, c) -> findOp.as(r).inScope(s).inCollection(c).matching(q.with(accessor.getPageable())).all();
        }
        if (this.getQueryMethod().isStreamQuery()) {
            return (q, t, r, s, c) -> findOp.as(r).inScope(s).inCollection(c).matching(q.with(accessor.getPageable())).stream();
        }
        if (this.isCountQuery()) {
            return (q, t, r, s, c) -> findOp.as(r).inScope(s).inCollection(c).matching(q).count();
        }
        if (this.isExistsQuery()) {
            return (q, t, r, s, c) -> findOp.as(r).inScope(s).inCollection(c).matching(q).exists();
        }
        if (this.getQueryMethod().isPageQuery()) {
            return new CouchbaseQueryExecution.PagedExecution(findOp, accessor.getPageable());
        }
        if (this.getQueryMethod().isSliceQuery()) {
            return new CouchbaseQueryExecution.SlicedExecution(findOp, accessor.getPageable());
        }
        return (q, t, r, s, c) -> {
            Object find = findOp.as(r).matching(q);
            if (this.isCountQuery()) {
                return find.count();
            }
            return this.isLimiting() ? find.first() : find.one();
        };
    }
}

