/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationRegistry;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnSingleCandidate;
import org.springframework.boot.restclient.observation.ObservationRestTemplateCustomizer;
import org.springframework.cloud.vault.config.VaultAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.observation.ClientRequestObservationConvention;
import org.springframework.http.client.observation.DefaultClientRequestObservationConvention;
import org.springframework.vault.client.RestTemplateCustomizer;

@Configuration(proxyBeanMethods=false)
@ConditionalOnClass(value={Observation.class, ObservationRestTemplateCustomizer.class})
@AutoConfigureBefore(value={VaultAutoConfiguration.class})
public class VaultObservationAutoConfiguration {
    @Bean
    @ConditionalOnSingleCandidate(value=ObservationRegistry.class)
    public RestTemplateCustomizer observationVaultRestTemplateCustomizer(ObservationRegistry observationRegistry) {
        return restTemplate -> new ObservationRestTemplateCustomizer(observationRegistry, (ClientRequestObservationConvention)new DefaultClientRequestObservationConvention()).customize(restTemplate);
    }
}

