/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.vault.config;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.ReactiveDiscoveryClient;
import reactor.core.publisher.Mono;

class ReacvtiveDiscoveryClientVaultServiceInstanceProvider {
    private static final Log log = LogFactory.getLog(ReacvtiveDiscoveryClientVaultServiceInstanceProvider.class);
    private final ReactiveDiscoveryClient client;

    ReacvtiveDiscoveryClientVaultServiceInstanceProvider(ReactiveDiscoveryClient client) {
        this.client = client;
    }

    Mono<ServiceInstance> getVaultServerInstance(String serviceId) {
        log.debug((Object)("Locating Vault server (" + serviceId + ") via discovery"));
        return this.client.getInstances(serviceId).collectList().handle((instances, sink) -> {
            if (instances.isEmpty()) {
                sink.error((Throwable)new IllegalStateException("No instances found of Vault server (" + serviceId + ")"));
                return;
            }
            ServiceInstance instance = (ServiceInstance)instances.get(0);
            log.debug((Object)("Located Vault server (" + serviceId + ") via discovery: " + String.valueOf(instance)));
            sink.next((Object)instance);
        });
    }
}

