/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.stream.binder;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.commons.logging.Log;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.beans.factory.support.DefaultSingletonBeanRegistry;
import org.springframework.cloud.function.context.FunctionCatalog;
import org.springframework.cloud.function.context.catalog.SimpleFunctionRegistry;
import org.springframework.cloud.stream.binder.AbstractBinder;
import org.springframework.cloud.stream.binder.BinderErrorChannel;
import org.springframework.cloud.stream.binder.BinderException;
import org.springframework.cloud.stream.binder.BinderType;
import org.springframework.cloud.stream.binder.Binding;
import org.springframework.cloud.stream.binder.BindingCreatedEvent;
import org.springframework.cloud.stream.binder.ConsumerProperties;
import org.springframework.cloud.stream.binder.DefaultBinderTypeRegistry;
import org.springframework.cloud.stream.binder.DefaultBinding;
import org.springframework.cloud.stream.binder.DefaultPollableMessageSource;
import org.springframework.cloud.stream.binder.EmbeddedHeaderUtils;
import org.springframework.cloud.stream.binder.ExtendedConsumerProperties;
import org.springframework.cloud.stream.binder.ExtendedProducerProperties;
import org.springframework.cloud.stream.binder.FinalRethrowingErrorMessageHandler;
import org.springframework.cloud.stream.binder.HeaderMode;
import org.springframework.cloud.stream.binder.MessageValues;
import org.springframework.cloud.stream.binder.PollableConsumerBinder;
import org.springframework.cloud.stream.binder.PollableSource;
import org.springframework.cloud.stream.binder.ProducerProperties;
import org.springframework.cloud.stream.config.BindingProperties;
import org.springframework.cloud.stream.config.BindingServiceProperties;
import org.springframework.cloud.stream.config.ConsumerEndpointCustomizer;
import org.springframework.cloud.stream.config.ListenerContainerCustomizer;
import org.springframework.cloud.stream.config.MessageSourceCustomizer;
import org.springframework.cloud.stream.config.ProducerMessageHandlerCustomizer;
import org.springframework.cloud.stream.provisioning.ConsumerDestination;
import org.springframework.cloud.stream.provisioning.ProducerDestination;
import org.springframework.cloud.stream.provisioning.ProvisioningException;
import org.springframework.cloud.stream.provisioning.ProvisioningProvider;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.Lifecycle;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.expression.Expression;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.channel.AbstractSubscribableChannel;
import org.springframework.integration.channel.DirectChannel;
import org.springframework.integration.channel.FluxMessageChannel;
import org.springframework.integration.channel.PublishSubscribeChannel;
import org.springframework.integration.core.MessageProducer;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.endpoint.ReactiveStreamsConsumer;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.handler.BridgeHandler;
import org.springframework.integration.handler.advice.ErrorMessageSendingRecoverer;
import org.springframework.integration.support.ErrorMessageStrategy;
import org.springframework.lang.Nullable;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;
import org.springframework.messaging.MessageHandler;
import org.springframework.messaging.SubscribableChannel;
import org.springframework.messaging.support.ChannelInterceptor;
import org.springframework.messaging.support.ErrorMessage;
import org.springframework.retry.RecoveryCallback;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class AbstractMessageChannelBinder<C extends ConsumerProperties, P extends ProducerProperties, PP extends ProvisioningProvider<C, P>>
extends AbstractBinder<MessageChannel, C, P>
implements PollableConsumerBinder<MessageHandler, C>,
ApplicationEventPublisherAware {
    protected final PP provisioningProvider;
    private final EmbeddedHeadersChannelInterceptor embeddedHeadersChannelInterceptor;
    private volatile ObjectMapper objectMapper;
    private final String[] headersToEmbed;
    private ListenerContainerCustomizer<?> containerCustomizer;
    private final MessageSourceCustomizer<?> sourceCustomizer;
    private ProducerMessageHandlerCustomizer<MessageHandler> handlerCustomizer;
    private ConsumerEndpointCustomizer<MessageProducer> consumerCustomizer;
    private ApplicationEventPublisher applicationEventPublisher;

    public AbstractMessageChannelBinder(String[] headersToEmbed, PP provisioningProvider) {
        this(headersToEmbed, provisioningProvider, null, null);
    }

    @Override
    protected void onInit() throws Exception {
        this.objectMapper = !CollectionUtils.isEmpty((Map)this.getApplicationContext().getBeansOfType(ObjectMapper.class)) ? (ObjectMapper)this.getApplicationContext().getBean(ObjectMapper.class) : new ObjectMapper();
        SimpleModule module = new SimpleModule();
        module.addSerializer(Expression.class, (JsonSerializer)new ExpressionSerializer(Expression.class));
        this.objectMapper.registerModules(new Module[]{module, new JavaTimeModule()});
    }

    public AbstractMessageChannelBinder(String[] headersToEmbed, PP provisioningProvider, @Nullable ListenerContainerCustomizer<?> containerCustomizer, @Nullable MessageSourceCustomizer<?> sourceCustomizer) {
        this.embeddedHeadersChannelInterceptor = new EmbeddedHeadersChannelInterceptor(this.logger);
        this.handlerCustomizer = (handler, destination) -> {};
        this.consumerCustomizer = (adapter, destination, group) -> {};
        this.headersToEmbed = headersToEmbed == null ? new String[]{} : headersToEmbed;
        this.provisioningProvider = provisioningProvider;
        this.containerCustomizer = containerCustomizer == null ? (c, q, g) -> {} : containerCustomizer;
        this.sourceCustomizer = sourceCustomizer == null ? (s, q, g) -> {} : sourceCustomizer;
    }

    protected ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setProducerMessageHandlerCustomizer(@Nullable ProducerMessageHandlerCustomizer<? extends MessageHandler> handlerCustomizer) {
        this.handlerCustomizer = handlerCustomizer == null ? (handler, destination) -> {} : handlerCustomizer;
    }

    public void setConsumerEndpointCustomizer(@Nullable ConsumerEndpointCustomizer<? extends MessageProducer> endpointCustomizer) {
        this.consumerCustomizer = endpointCustomizer == null ? (handler, destination, group) -> {} : endpointCustomizer;
    }

    public void setContainerCustomizer(@Nullable ListenerContainerCustomizer<?> containerCustomizer) {
        this.containerCustomizer = containerCustomizer == null ? (container, destinationName, group) -> {} : containerCustomizer;
    }

    protected <L> ListenerContainerCustomizer<L> getContainerCustomizer() {
        return this.containerCustomizer;
    }

    protected <S> MessageSourceCustomizer<S> getMessageSourceCustomizer() {
        return this.sourceCustomizer;
    }

    private String resolveBinderName(String bindingName, BindingServiceProperties bindingServiceProperties) {
        String binder = AbstractMessageChannelBinder.resolveBinder(bindingName, bindingServiceProperties);
        if (!StringUtils.hasText((String)binder)) {
            return this.resolveFromDefaultBinder();
        }
        return binder;
    }

    private String resolveBinderType(String bindingName, BindingServiceProperties bindingServiceProperties) {
        String binder = AbstractMessageChannelBinder.resolveBinder(bindingName, bindingServiceProperties);
        if (!StringUtils.hasText((String)binder)) {
            return this.resolveFromDefaultBinder();
        }
        if (bindingServiceProperties.getBinders().get(binder) == null) {
            return binder;
        }
        return bindingServiceProperties.getBinders().get(binder).getType();
    }

    private static String resolveBinder(String bindingName, BindingServiceProperties bindingServiceProperties) {
        BindingProperties bindingProperties;
        String binder = null;
        if (bindingServiceProperties != null && (bindingProperties = bindingServiceProperties.getBindings().get(bindingName)) != null) {
            binder = bindingProperties.getBinder();
        }
        return binder;
    }

    private String resolveFromDefaultBinder() {
        DefaultBinderTypeRegistry binderTypeRegistry = (DefaultBinderTypeRegistry)this.getApplicationContext().getBean(DefaultBinderTypeRegistry.class);
        Map<String, BinderType> binderTypes = binderTypeRegistry.getAll();
        if (binderTypes.entrySet().size() > 1 && this.getBindingServiceProperties().getDefaultBinder() != null) {
            return this.getBindingServiceProperties().getDefaultBinder();
        }
        Assert.isTrue((binderTypes.entrySet().size() <= 1 ? 1 : 0) != 0, (String)"More than one binder types found, but no binder specified on the binding");
        return binderTypes.entrySet().size() < 1 ? null : binderTypes.keySet().iterator().next();
    }

    @Override
    public final Binding<MessageChannel> doBindProducer(final String destination, MessageChannel outputChannel, final P producerProperties) throws BinderException {
        Lifecycle producerMessageHandlerWithLifecycle;
        MessageHandler producerMessageHandler;
        BindingServiceProperties bsp;
        ProducerDestination producerDestination;
        try {
            producerDestination = this.provisioningProvider.provisionProducerDestination(destination, producerProperties);
            BindingProperties bp = null;
            bsp = this.getBindingServiceProperties();
            if (bsp != null) {
                String bindingName = StringUtils.hasText((String)((ProducerProperties)producerProperties).getBindingName()) ? ((ProducerProperties)producerProperties).getBindingName() : destination;
                bp = bsp.getBindingProperties(bindingName);
            }
            boolean errorHandlerDefined = bp != null && StringUtils.hasText((String)bp.getErrorHandlerDefinition());
            SubscribableChannel errorChannel = errorHandlerDefined || ((ProducerProperties)producerProperties).isErrorChannelEnabled() ? this.registerErrorInfrastructure(producerDestination, ((ProducerProperties)producerProperties).getBindingName(), errorHandlerDefined) : null;
            String errorChannelName = this.errorsBaseName(producerDestination, ((ProducerProperties)producerProperties).getBindingName());
            this.subscribeFunctionErrorHandler(errorChannelName, ((ProducerProperties)producerProperties).getBindingName());
            producerMessageHandler = this.createProducerMessageHandler(producerDestination, producerProperties, outputChannel, (MessageChannel)errorChannel);
            this.customizeProducerMessageHandler(producerMessageHandler, producerDestination.getName());
            if (producerMessageHandler instanceof InitializingBean) {
                InitializingBean initializingHandler = (InitializingBean)producerMessageHandler;
                initializingHandler.afterPropertiesSet();
            }
        }
        catch (Exception e) {
            if (e instanceof BinderException) {
                BinderException binderException = (BinderException)e;
                throw binderException;
            }
            if (e instanceof ProvisioningException) {
                ProvisioningException provisioningException = (ProvisioningException)((Object)e);
                throw provisioningException;
            }
            throw new BinderException("Exception thrown while building outbound endpoint", e);
        }
        if (((ProducerProperties)producerProperties).isAutoStartup() && producerMessageHandler instanceof Lifecycle) {
            Lifecycle ProducerMessageHandlerWithLifeCycle = (Lifecycle)producerMessageHandler;
            ProducerMessageHandlerWithLifeCycle.start();
        }
        this.postProcessOutputChannel(outputChannel, producerProperties);
        final AtomicReference<ReactiveStreamsConsumer> reactiveStreamsConsumerRef = new AtomicReference<ReactiveStreamsConsumer>();
        if (outputChannel instanceof SubscribableChannel) {
            SubscribableChannel subscribableOutputChannel = (SubscribableChannel)outputChannel;
            subscribableOutputChannel.subscribe((MessageHandler)new SendingHandler(producerMessageHandler, HeaderMode.embeddedHeaders.equals((Object)((ProducerProperties)producerProperties).getHeaderMode()), this.headersToEmbed, this.useNativeEncoding(producerProperties)));
        } else if (outputChannel instanceof FluxMessageChannel) {
            ReactiveStreamsConsumer reactiveStreamsConsumer = new ReactiveStreamsConsumer(outputChannel, producerMessageHandler);
            reactiveStreamsConsumerRef.set(reactiveStreamsConsumer);
            reactiveStreamsConsumer.start();
        } else {
            throw new IllegalStateException("No capable binding targets found.");
        }
        bsp = this.getBindingServiceProperties();
        DefaultBinding<MessageChannel> binding = new DefaultBinding<MessageChannel>(destination, outputChannel, producerMessageHandler instanceof Lifecycle ? (producerMessageHandlerWithLifecycle = (Lifecycle)producerMessageHandler) : null){

            @Override
            public Map<String, Object> getExtendedInfo() {
                return AbstractMessageChannelBinder.this.doGetExtendedInfo(destination, producerProperties);
            }

            @Override
            public <P> P getExtension() {
                if (producerProperties instanceof ExtendedProducerProperties) {
                    ExtendedProducerProperties extendedProperties = (ExtendedProducerProperties)producerProperties;
                    return (P)extendedProperties.getExtension();
                }
                return null;
            }

            @Override
            public boolean isInput() {
                return false;
            }

            @Override
            public String getBinderName() {
                return AbstractMessageChannelBinder.this.resolveBinderName(this.getBindingName(), bsp);
            }

            @Override
            public String getBinderType() {
                return AbstractMessageChannelBinder.this.resolveBinderType(this.getBindingName(), bsp);
            }

            @Override
            public void afterUnbind() {
                try {
                    AbstractMessageChannelBinder.this.destroyErrorInfrastructure(producerDestination, producerProperties.getBindingName());
                    ReactiveStreamsConsumer rsc = (ReactiveStreamsConsumer)reactiveStreamsConsumerRef.get();
                    if (rsc != null && rsc.isRunning()) {
                        rsc.destroy();
                    }
                    if (producerMessageHandler instanceof DisposableBean) {
                        DisposableBean disposableProducerMessageHandler = (DisposableBean)producerMessageHandler;
                        disposableProducerMessageHandler.destroy();
                    }
                }
                catch (Exception e) {
                    AbstractMessageChannelBinder.this.logger.error((Object)("Exception thrown while unbinding " + this.toString()), (Throwable)e);
                }
                AbstractMessageChannelBinder.this.afterUnbindProducer(producerDestination, producerProperties);
            }
        };
        Lifecycle companion = null;
        String outputChannelName = ((AbstractMessageChannel)outputChannel).getBeanName();
        String companionLifecycleName = outputChannelName + "_spca";
        if (this.getApplicationContext().containsBean(companionLifecycleName)) {
            companion = (Lifecycle)this.getApplicationContext().getBean(companionLifecycleName, Lifecycle.class);
        }
        ((DefaultBinding)binding).setCompanion(companion);
        this.doPublishEvent(new BindingCreatedEvent(binding));
        return binding;
    }

    protected void customizeProducerMessageHandler(MessageHandler producerMessageHandler, String destinationName) {
        this.handlerCustomizer.configure(producerMessageHandler, destinationName);
    }

    protected boolean useNativeEncoding(P producerProperties) {
        return ((ProducerProperties)producerProperties).isUseNativeEncoding();
    }

    protected void postProcessOutputChannel(MessageChannel outputChannel, P producerProperties) {
    }

    protected MessageHandler createProducerMessageHandler(ProducerDestination destination, P producerProperties, MessageChannel channel, MessageChannel errorChannel) throws Exception {
        return this.createProducerMessageHandler(destination, producerProperties, errorChannel);
    }

    protected abstract MessageHandler createProducerMessageHandler(ProducerDestination var1, P var2, MessageChannel var3) throws Exception;

    protected void afterUnbindProducer(ProducerDestination destination, P producerProperties) {
    }

    @Override
    public final Binding<MessageChannel> doBindConsumer(String name, String group, MessageChannel inputChannel, final C properties) throws BinderException {
        MessageProducer consumerEndpoint = null;
        try {
            Lifecycle consumerEndpointWithLifecycle;
            final ConsumerDestination destination = this.provisioningProvider.provisionConsumerDestination(name, group, properties);
            if (HeaderMode.embeddedHeaders.equals((Object)((ConsumerProperties)properties).getHeaderMode())) {
                this.enhanceMessageChannel(inputChannel);
            }
            consumerEndpoint = this.createConsumerEndpoint(destination, group, properties);
            consumerEndpoint.setOutputChannel(inputChannel);
            this.consumerCustomizer.configure(consumerEndpoint, name, group);
            if (consumerEndpoint instanceof InitializingBean) {
                InitializingBean initializingConsumerEndpoint = (InitializingBean)consumerEndpoint;
                initializingConsumerEndpoint.afterPropertiesSet();
            }
            if (((ConsumerProperties)properties).isAutoStartup() && consumerEndpoint instanceof Lifecycle) {
                Lifecycle consumerEndpointWithLifecycle2 = (Lifecycle)consumerEndpoint;
                consumerEndpointWithLifecycle2.start();
            }
            final BindingServiceProperties bsp = this.getBindingServiceProperties();
            DefaultBinding<MessageChannel> binding = new DefaultBinding<MessageChannel>(name, group, inputChannel, consumerEndpoint instanceof Lifecycle ? (consumerEndpointWithLifecycle = (Lifecycle)consumerEndpoint) : null){

                @Override
                public Map<String, Object> getExtendedInfo() {
                    return AbstractMessageChannelBinder.this.doGetExtendedInfo(destination, properties);
                }

                @Override
                public <P> P getExtension() {
                    if (properties instanceof ExtendedConsumerProperties) {
                        ExtendedConsumerProperties extendedProperties = (ExtendedConsumerProperties)properties;
                        return (P)extendedProperties.getExtension();
                    }
                    return null;
                }

                @Override
                public boolean isInput() {
                    return true;
                }

                @Override
                public String getBinderName() {
                    return AbstractMessageChannelBinder.this.resolveBinderName(this.getBindingName(), bsp);
                }

                @Override
                public String getBinderType() {
                    return AbstractMessageChannelBinder.this.resolveBinderType(this.getBindingName(), bsp);
                }

                @Override
                public Map<String, Object> getAdditionalConfigurationProperties() {
                    return AbstractMessageChannelBinder.this.doGetAdditionalConfigurationProperties(this.getName());
                }

                @Override
                protected void afterUnbind() {
                    try {
                        Lifecycle lifecycle = this.getEndpoint();
                        if (lifecycle instanceof DisposableBean) {
                            DisposableBean disposableEndpoint = (DisposableBean)lifecycle;
                            disposableEndpoint.destroy();
                        }
                    }
                    catch (Exception e) {
                        AbstractMessageChannelBinder.this.logger.error((Object)("Exception thrown while unbinding " + this.toString()), (Throwable)e);
                    }
                    AbstractMessageChannelBinder.this.afterUnbindConsumer(destination, this.group, properties);
                    AbstractMessageChannelBinder.this.destroyErrorInfrastructure(destination, this.group, properties);
                }
            };
            this.doPublishEvent(new BindingCreatedEvent(binding));
            return binding;
        }
        catch (Exception e) {
            if (consumerEndpoint instanceof Lifecycle) {
                Lifecycle consumerEndpointWithLifecycle = (Lifecycle)consumerEndpoint;
                consumerEndpointWithLifecycle.stop();
            }
            if (e instanceof BinderException) {
                BinderException binderException = (BinderException)e;
                throw binderException;
            }
            if (e instanceof ProvisioningException) {
                ProvisioningException provisioningException = (ProvisioningException)((Object)e);
                throw provisioningException;
            }
            throw new BinderException("Exception thrown while starting consumer: ", e);
        }
    }

    protected Map<String, Object> doGetAdditionalConfigurationProperties(String name) {
        this.logger.warn((Object)"This method must be implemented by an individual binders to produce an immutable version of additional configuration properties primarily for testing and diagnosing/debugging issues");
        return null;
    }

    @Override
    public Binding<PollableSource<MessageHandler>> bindPollableConsumer(String name, String group, PollableSource<MessageHandler> inboundBindTarget, final C properties) {
        Lifecycle sourceWithLifecycle;
        MessageSource<?> messageSource;
        PolledConsumerResources resources;
        MessageSource<?> messageSource2;
        Assert.isInstanceOf(DefaultPollableMessageSource.class, inboundBindTarget);
        DefaultPollableMessageSource bindingTarget = (DefaultPollableMessageSource)inboundBindTarget;
        final ConsumerDestination destination = this.provisioningProvider.provisionConsumerDestination(name, group, properties);
        if (HeaderMode.embeddedHeaders.equals((Object)((ConsumerProperties)properties).getHeaderMode())) {
            bindingTarget.addInterceptor(0, this.embeddedHeadersChannelInterceptor);
        }
        if ((messageSource2 = (resources = this.createPolledConsumerResources(name, group, destination, properties)).getSource()) instanceof BeanFactoryAware) {
            BeanFactoryAware beanFactoryAwareMessageSource = (BeanFactoryAware)messageSource2;
            beanFactoryAwareMessageSource.setBeanFactory((BeanFactory)this.getApplicationContext().getBeanFactory());
        }
        bindingTarget.setSource(messageSource2);
        if (resources.getErrorInfrastructure() != null) {
            ErrorMessageStrategy ems;
            if (resources.getErrorInfrastructure().getErrorChannel() != null) {
                bindingTarget.setErrorChannel((MessageChannel)resources.getErrorInfrastructure().getErrorChannel());
            }
            if ((ems = this.getErrorMessageStrategy()) != null) {
                bindingTarget.setErrorMessageStrategy(ems);
            }
        }
        if (((ConsumerProperties)properties).getMaxAttempts() > 1) {
            bindingTarget.setRetryTemplate(this.buildRetryTemplate((ConsumerProperties)properties));
            bindingTarget.setRecoveryCallback(this.getPolledConsumerRecoveryCallback(resources.getErrorInfrastructure(), properties));
        }
        this.postProcessPollableSource(bindingTarget);
        if (((ConsumerProperties)properties).isAutoStartup() && (messageSource = resources.getSource()) instanceof Lifecycle) {
            Lifecycle sourceWithLifecycle2 = (Lifecycle)messageSource;
            sourceWithLifecycle2.start();
        }
        final BindingServiceProperties bsp = this.getBindingServiceProperties();
        MessageSource<?> messageSource3 = resources.getSource();
        DefaultBinding<PollableSource<MessageHandler>> binding = new DefaultBinding<PollableSource<MessageHandler>>(name, group, inboundBindTarget, messageSource3 instanceof Lifecycle ? (sourceWithLifecycle = (Lifecycle)messageSource3) : null){

            @Override
            public Map<String, Object> getExtendedInfo() {
                return AbstractMessageChannelBinder.this.doGetExtendedInfo(destination, properties);
            }

            @Override
            public boolean isInput() {
                return true;
            }

            @Override
            public String getBinderName() {
                return AbstractMessageChannelBinder.this.resolveBinderName(properties.getBindingName(), bsp);
            }

            @Override
            public String getBinderType() {
                return AbstractMessageChannelBinder.this.resolveBinderType(properties.getBindingName(), bsp);
            }

            @Override
            public void afterUnbind() {
                AbstractMessageChannelBinder.this.afterUnbindConsumer(destination, this.group, properties);
                AbstractMessageChannelBinder.this.destroyErrorInfrastructure(destination, this.group, properties);
            }
        };
        this.doPublishEvent(new BindingCreatedEvent(binding));
        return binding;
    }

    protected void postProcessPollableSource(DefaultPollableMessageSource bindingTarget) {
    }

    protected RecoveryCallback<Object> getPolledConsumerRecoveryCallback(ErrorInfrastructure errorInfrastructure, C properties) {
        return errorInfrastructure.getRecoverer();
    }

    protected PolledConsumerResources createPolledConsumerResources(String name, String group, ConsumerDestination destination, C consumerProperties) {
        throw new UnsupportedOperationException("This binder does not support pollable consumers");
    }

    private void enhanceMessageChannel(MessageChannel inputChannel) {
        ((AbstractMessageChannel)inputChannel).addInterceptor(0, (ChannelInterceptor)this.embeddedHeadersChannelInterceptor);
    }

    protected abstract MessageProducer createConsumerEndpoint(ConsumerDestination var1, String var2, C var3) throws Exception;

    protected void afterUnbindConsumer(ConsumerDestination destination, String group, C consumerProperties) {
    }

    private SubscribableChannel registerErrorInfrastructure(ProducerDestination destination, String bindingName, boolean errorHandlerDefinitionAvailable) {
        Object errorChannelName = this.errorsBaseName(destination, bindingName);
        PublishSubscribeChannel errorChannel = new PublishSubscribeChannel();
        if (this.getApplicationContext().containsBean((String)errorChannelName)) {
            Object errorChannelObject = this.getApplicationContext().getBean((String)errorChannelName);
            if (!(errorChannelObject instanceof SubscribableChannel)) {
                throw new IllegalStateException("Error channel '" + (String)errorChannelName + "' must be a SubscribableChannel");
            }
            if (errorChannelObject instanceof DirectChannel) {
                errorChannelName = "bridged." + (String)errorChannelName;
                BridgeHandler bridge = new BridgeHandler();
                bridge.setOutputChannel((MessageChannel)errorChannelObject);
                errorChannel.subscribe((MessageHandler)bridge);
            }
        } else {
            ((GenericApplicationContext)this.getApplicationContext()).registerBean((String)errorChannelName, SubscribableChannel.class, () -> AbstractMessageChannelBinder.lambda$registerErrorInfrastructure$7((SubscribableChannel)errorChannel), new BeanDefinitionCustomizer[0]);
        }
        MessageChannel defaultErrorChannel = null;
        if (!errorHandlerDefinitionAvailable && this.getApplicationContext().containsBean("errorChannel")) {
            defaultErrorChannel = (MessageChannel)this.getApplicationContext().getBean("errorChannel", MessageChannel.class);
        }
        if (defaultErrorChannel != null) {
            BridgeHandler errorBridge = new BridgeHandler();
            errorBridge.setOutputChannel(defaultErrorChannel);
            errorChannel.subscribe((MessageHandler)errorBridge);
            String errorBridgeHandlerName = this.getErrorBridgeName(destination, bindingName);
            ((GenericApplicationContext)this.getApplicationContext()).registerBean(errorBridgeHandlerName, BridgeHandler.class, () -> errorBridge, new BeanDefinitionCustomizer[0]);
        }
        return errorChannel;
    }

    protected final ErrorInfrastructure registerErrorInfrastructure(ConsumerDestination destination, String group, C consumerProperties) {
        return this.registerErrorInfrastructure(destination, group, consumerProperties, false);
    }

    private boolean subscribeFunctionErrorHandler(String errorChannelName, String bindingName) {
        BindingProperties bp;
        if (!StringUtils.hasText((String)bindingName)) {
            return false;
        }
        BindingServiceProperties bsp = this.getBindingServiceProperties();
        if (bsp != null && (bp = bsp.getBindingProperties(bindingName)) != null && StringUtils.hasText((String)bp.getErrorHandlerDefinition())) {
            FunctionCatalog catalog = (FunctionCatalog)this.getApplicationContext().getBean(FunctionCatalog.class);
            Consumer errorHandler = (Consumer)catalog.lookup(Consumer.class, bp.getErrorHandlerDefinition());
            if (errorHandler == null) {
                this.logger.warn((Object)("Failed to retrieve error handling function with definition: " + bp.getErrorHandlerDefinition() + ", for binding: " + bindingName));
                return false;
            }
            SubscribableChannel functionErrorChannel = (SubscribableChannel)this.getApplicationContext().getBean(errorChannelName, SubscribableChannel.class);
            functionErrorChannel.subscribe(errorMessage -> errorHandler.accept((ErrorMessage)errorMessage));
            return true;
        }
        return false;
    }

    protected final ErrorInfrastructure registerErrorInfrastructure(ConsumerDestination destination, String group, C consumerProperties, boolean polled) {
        BinderErrorChannel binderErrorChannel;
        ErrorMessageStrategy errorMessageStrategy = this.getErrorMessageStrategy();
        String errorChannelName = this.errorsBaseName(destination, group, consumerProperties);
        BindingServiceProperties bsp = this.getBindingServiceProperties();
        SimpleFunctionRegistry.FunctionInvocationWrapper userErrorHandler = null;
        String errorHandlerDefinition = null;
        if (bsp != null && StringUtils.hasText((String)((ConsumerProperties)consumerProperties).getBindingName())) {
            BindingProperties bp = bsp.getBindingProperties(((ConsumerProperties)consumerProperties).getBindingName());
            errorHandlerDefinition = bp.getErrorHandlerDefinition();
            FunctionCatalog catalog = (FunctionCatalog)this.getApplicationContext().getBean(FunctionCatalog.class);
            if (StringUtils.hasText((String)errorHandlerDefinition) && ((userErrorHandler = (SimpleFunctionRegistry.FunctionInvocationWrapper)catalog.lookup(errorHandlerDefinition)) == null || !userErrorHandler.getFunctionDefinition().equals(errorHandlerDefinition))) {
                userErrorHandler = null;
            }
        }
        if (this.getApplicationContext().containsBean(errorChannelName)) {
            binderErrorChannel = (AbstractSubscribableChannel)this.getApplicationContext().getBean(errorChannelName, AbstractSubscribableChannel.class);
        } else {
            binderErrorChannel = new BinderErrorChannel();
            binderErrorChannel.setComponentName(errorChannelName);
            ((GenericApplicationContext)this.getApplicationContext()).registerBean(errorChannelName, SubscribableChannel.class, () -> AbstractMessageChannelBinder.lambda$registerErrorInfrastructure$10((AbstractSubscribableChannel)binderErrorChannel), new BeanDefinitionCustomizer[0]);
        }
        boolean userHandlerSubscribed = this.subscribeFunctionErrorHandler(errorChannelName, ((ConsumerProperties)consumerProperties).getBindingName());
        ErrorMessageSendingRecoverer recoverer = new ErrorMessageSendingRecoverer((MessageChannel)binderErrorChannel, errorMessageStrategy);
        String recovererBeanName = this.getErrorRecovererName(destination, group, consumerProperties);
        if (!this.getApplicationContext().containsBean(recovererBeanName)) {
            ((GenericApplicationContext)this.getApplicationContext()).registerBean(recovererBeanName, ErrorMessageSendingRecoverer.class, () -> recoverer, new BeanDefinitionCustomizer[0]);
        }
        MessageHandler binderProvidedErrorHandler = polled ? this.getPolledConsumerErrorMessageHandler(destination, group, consumerProperties) : this.getErrorMessageHandler(destination, group, consumerProperties);
        String errorMessageHandlerName = this.getErrorMessageHandlerName(destination, group, consumerProperties);
        if (binderProvidedErrorHandler == null) {
            binderProvidedErrorHandler = this.getDefaultErrorMessageHandler(binderErrorChannel, polled);
        }
        if (binderProvidedErrorHandler != null && !userHandlerSubscribed) {
            if (this.isSubscribable(binderErrorChannel) && !this.getApplicationContext().containsBean(errorMessageHandlerName)) {
                MessageHandler h = binderProvidedErrorHandler;
                ((GenericApplicationContext)this.getApplicationContext()).registerBean(errorMessageHandlerName, MessageHandler.class, () -> h, new BeanDefinitionCustomizer[0]);
                binderErrorChannel.subscribe(binderProvidedErrorHandler);
            } else {
                this.logger.warn((Object)("The provided errorChannel '" + errorChannelName + "' is an instance of DirectChannel, so no more subscribers could be added which may affect DLQ processing. Resolution: Configure your own errorChannel as an instance of PublishSubscribeChannel"));
            }
        }
        if (this.getApplicationContext().containsBean("errorChannel") && this.isSubscribable(binderErrorChannel)) {
            String errorBridgeHandlerName = this.getErrorBridgeName(destination, group, consumerProperties);
            if (!this.getApplicationContext().containsBean(errorBridgeHandlerName)) {
                SubscribableChannel globalErrorChannel = (SubscribableChannel)this.getApplicationContext().getBean("errorChannel", SubscribableChannel.class);
                BridgeHandler bridge = new BridgeHandler();
                bridge.setOutputChannel((MessageChannel)globalErrorChannel);
                binderErrorChannel.subscribe((MessageHandler)bridge);
                ((GenericApplicationContext)this.getApplicationContext()).registerBean(errorBridgeHandlerName, BridgeHandler.class, () -> bridge, new BeanDefinitionCustomizer[0]);
            }
        }
        return new ErrorInfrastructure(binderErrorChannel, recoverer, binderProvidedErrorHandler);
    }

    private boolean isSubscribable(SubscribableChannel errorChannel) {
        AbstractSubscribableChannel subscribableErrorChannel;
        if (errorChannel instanceof PublishSubscribeChannel) {
            return true;
        }
        return !(errorChannel instanceof AbstractSubscribableChannel) || (subscribableErrorChannel = (AbstractSubscribableChannel)errorChannel).getSubscriberCount() == 0;
    }

    private void destroyErrorInfrastructure(ProducerDestination destination, String bindingName) {
        String errorChannelName = this.errorsBaseName(destination, bindingName);
        String errorBridgeHandlerName = this.getErrorBridgeName(destination, bindingName);
        MessageHandler bridgeHandler = null;
        if (this.getApplicationContext().containsBean(errorBridgeHandlerName)) {
            bridgeHandler = (MessageHandler)this.getApplicationContext().getBean(errorBridgeHandlerName, MessageHandler.class);
        }
        if (this.getApplicationContext().containsBean(errorChannelName)) {
            SubscribableChannel channel = (SubscribableChannel)this.getApplicationContext().getBean(errorChannelName, SubscribableChannel.class);
            if (bridgeHandler != null) {
                channel.unsubscribe(bridgeHandler);
                ((DefaultSingletonBeanRegistry)this.getApplicationContext().getBeanFactory()).destroySingleton(errorBridgeHandlerName);
            }
            ((DefaultSingletonBeanRegistry)this.getApplicationContext().getBeanFactory()).destroySingleton(errorChannelName);
        }
    }

    private void destroyErrorInfrastructure(ConsumerDestination destination, String group, C properties) {
        try {
            String recoverer = this.getErrorRecovererName(destination, group, properties);
            this.destroyBean(recoverer);
            String errorChannelName = this.errorsBaseName(destination, group, properties);
            String errorMessageHandlerName = this.getErrorMessageHandlerName(destination, group, properties);
            String errorBridgeHandlerName = this.getErrorBridgeName(destination, group, properties);
            MessageHandler bridgeHandler = null;
            if (this.getApplicationContext().containsBean(errorBridgeHandlerName)) {
                bridgeHandler = (MessageHandler)this.getApplicationContext().getBean(errorBridgeHandlerName, MessageHandler.class);
            }
            MessageHandler handler = null;
            if (this.getApplicationContext().containsBean(errorMessageHandlerName)) {
                handler = (MessageHandler)this.getApplicationContext().getBean(errorMessageHandlerName, MessageHandler.class);
            }
            if (this.getApplicationContext().containsBean(errorChannelName)) {
                SubscribableChannel channel = (SubscribableChannel)this.getApplicationContext().getBean(errorChannelName, SubscribableChannel.class);
                if (bridgeHandler != null) {
                    channel.unsubscribe(bridgeHandler);
                    this.destroyBean(errorBridgeHandlerName);
                }
                if (handler != null) {
                    channel.unsubscribe(handler);
                    this.destroyBean(errorMessageHandlerName);
                }
                this.destroyBean(errorChannelName);
            }
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void destroyBean(String beanName) {
        if (this.getApplicationContext().containsBeanDefinition(beanName)) {
            ((DefaultSingletonBeanRegistry)this.getApplicationContext().getBeanFactory()).destroySingleton(beanName);
            ((GenericApplicationContext)this.getApplicationContext()).removeBeanDefinition(beanName);
        }
    }

    protected MessageHandler getErrorMessageHandler(ConsumerDestination destination, String group, C consumerProperties) {
        return null;
    }

    protected MessageHandler getPolledConsumerErrorMessageHandler(ConsumerDestination destination, String group, C consumerProperties) {
        return null;
    }

    protected MessageHandler getDefaultErrorMessageHandler(SubscribableChannel errorChannel, boolean defaultErrorChannelPresent) {
        return new FinalRethrowingErrorMessageHandler();
    }

    protected ErrorMessageStrategy getErrorMessageStrategy() {
        return null;
    }

    protected String getErrorRecovererName(ConsumerDestination destination, String group, C consumerProperties) {
        return this.errorsBaseName(destination, group, consumerProperties) + ".recoverer";
    }

    protected String getErrorMessageHandlerName(ConsumerDestination destination, String group, C consumerProperties) {
        return this.errorsBaseName(destination, group, consumerProperties) + ".handler";
    }

    protected String getErrorBridgeName(ConsumerDestination destination, String group, C consumerProperties) {
        return this.errorsBaseName(destination, group, consumerProperties) + ".bridge";
    }

    protected String errorsBaseName(ConsumerDestination destination, String group, C consumerProperties) {
        return this.doErrorBaseName(((ConsumerProperties)consumerProperties).getBindingName());
    }

    protected String getErrorBridgeName(ProducerDestination destination, String bindingName) {
        return this.errorsBaseName(destination, bindingName) + ".bridge" + destination.hashCode();
    }

    protected String errorsBaseName(ProducerDestination destination, String bindingName) {
        return this.doErrorBaseName(bindingName);
    }

    private String doErrorBaseName(String bindingName) {
        return this.getBinderIdentity() + "." + bindingName + ".errors";
    }

    private Map<String, Object> doGetExtendedInfo(Object destination, Object properties) {
        LinkedHashMap<String, Object> extendedInfo = new LinkedHashMap<String, Object>();
        extendedInfo.put("bindingDestination", destination.toString());
        extendedInfo.put(properties.getClass().getSimpleName(), this.objectMapper.convertValue(properties, Map.class));
        return extendedInfo;
    }

    private void doPublishEvent(ApplicationEvent event) {
        if (this.applicationEventPublisher != null) {
            try {
                this.applicationEventPublisher.publishEvent(event);
            }
            catch (Exception e) {
                this.logger.warn((Object)("Failed while publishing event " + event + ". From the framework perspective this is harmless and typically happens when use implement custom ApplicationListener"));
                this.logger.debug((Object)e);
            }
        }
    }

    private static /* synthetic */ SubscribableChannel lambda$registerErrorInfrastructure$10(AbstractSubscribableChannel binderErrorChannel) {
        return binderErrorChannel;
    }

    private static /* synthetic */ SubscribableChannel lambda$registerErrorInfrastructure$7(SubscribableChannel errorChannel) {
        return errorChannel;
    }

    private static class ExpressionSerializer
    extends StdSerializer<Expression> {
        protected ExpressionSerializer(Class<Expression> t) {
            super(t);
        }

        public void serialize(Expression value, JsonGenerator gen, SerializerProvider provider) throws IOException {
            gen.writeString(value.getExpressionString());
        }
    }

    private static final class EmbeddedHeadersChannelInterceptor
    implements ChannelInterceptor {
        protected final Log logger;

        EmbeddedHeadersChannelInterceptor(Log logger) {
            this.logger = logger;
        }

        public Message<?> preSend(Message<?> message, MessageChannel channel) {
            Object object = message.getPayload();
            if (object instanceof byte[]) {
                byte[] messagePayload = (byte[])object;
                if (!message.getHeaders().containsKey((Object)"scst_nativeHeadersPresent") && EmbeddedHeaderUtils.mayHaveEmbeddedHeaders(messagePayload)) {
                    MessageValues messageValues;
                    try {
                        messageValues = EmbeddedHeaderUtils.extractHeaders(message, true);
                    }
                    catch (Exception e) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug((Object)EmbeddedHeaderUtils.decodeExceptionMessage(message), (Throwable)e);
                        }
                        messageValues = new MessageValues(message);
                    }
                    return messageValues.toMessage();
                }
            }
            return message;
        }
    }

    private final class SendingHandler
    extends AbstractMessageHandler
    implements Lifecycle {
        private final boolean embedHeaders;
        private final String[] embeddedHeaders;
        private final MessageHandler delegate;
        private final boolean useNativeEncoding;

        private SendingHandler(MessageHandler delegate, boolean embedHeaders, String[] headersToEmbed, boolean useNativeEncoding) {
            this.delegate = delegate;
            this.setBeanFactory((BeanFactory)AbstractMessageChannelBinder.this.getBeanFactory());
            this.embedHeaders = embedHeaders;
            this.embeddedHeaders = headersToEmbed;
            this.useNativeEncoding = useNativeEncoding;
        }

        protected void handleMessageInternal(Message<?> message) {
            Message<?> messageToSend = this.useNativeEncoding ? message : this.serializeAndEmbedHeadersIfApplicable(message);
            this.delegate.handleMessage(messageToSend);
        }

        private Message<?> serializeAndEmbedHeadersIfApplicable(Message<?> message) {
            Object payload;
            MessageValues transformed = new MessageValues(message);
            if (this.embedHeaders) {
                Object contentType = transformed.get("contentType");
                if (contentType != null) {
                    transformed.put("contentType", (Object)contentType.toString());
                }
                payload = EmbeddedHeaderUtils.embedHeaders(transformed, this.embeddedHeaders);
            } else {
                payload = transformed.getPayload();
            }
            return this.getMessageBuilderFactory().withPayload(payload).copyHeaders(transformed.getHeaders()).build();
        }

        public void start() {
            MessageHandler messageHandler = this.delegate;
            if (messageHandler instanceof Lifecycle) {
                Lifecycle delegateWithLifecycle = (Lifecycle)messageHandler;
                delegateWithLifecycle.start();
            }
        }

        public void stop() {
            MessageHandler messageHandler = this.delegate;
            if (messageHandler instanceof Lifecycle) {
                Lifecycle delegateWithLifecycle = (Lifecycle)messageHandler;
                delegateWithLifecycle.stop();
            }
        }

        public boolean isRunning() {
            Lifecycle delegateWithLifecycle;
            MessageHandler messageHandler = this.delegate;
            return messageHandler instanceof Lifecycle && (delegateWithLifecycle = (Lifecycle)messageHandler).isRunning();
        }
    }

    protected static class PolledConsumerResources {
        private final MessageSource<?> source;
        private final ErrorInfrastructure errorInfrastructure;

        public PolledConsumerResources(MessageSource<?> source, ErrorInfrastructure errorInfrastructure) {
            this.source = source;
            this.errorInfrastructure = errorInfrastructure;
        }

        MessageSource<?> getSource() {
            return this.source;
        }

        ErrorInfrastructure getErrorInfrastructure() {
            return this.errorInfrastructure;
        }
    }

    protected static class ErrorInfrastructure {
        private final SubscribableChannel errorChannel;
        private final ErrorMessageSendingRecoverer recoverer;
        private final MessageHandler handler;

        ErrorInfrastructure(SubscribableChannel errorChannel, ErrorMessageSendingRecoverer recoverer, MessageHandler handler) {
            this.errorChannel = errorChannel;
            this.recoverer = recoverer;
            this.handler = handler;
        }

        public SubscribableChannel getErrorChannel() {
            return this.errorChannel;
        }

        public ErrorMessageSendingRecoverer getRecoverer() {
            return this.recoverer;
        }

        public MessageHandler getHandler() {
            return this.handler;
        }
    }
}

