/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.otel.zipkin2;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.exporter.zipkin.ZipkinSpanExporter;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.util.function.Supplier;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.autoconfig.zipkin2.ZipkinAutoConfiguration;
import org.springframework.cloud.sleuth.zipkin2.EndpointLocator;
import org.springframework.cloud.sleuth.zipkin2.ZipkinProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import zipkin2.codec.BytesEncoder;
import zipkin2.reporter.Sender;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.sleuth.enabled", "spring.zipkin.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={Tracer.class, EndpointLocator.class})
@AutoConfigureBefore(value={ZipkinAutoConfiguration.class})
public class ZipkinOtelAutoConfiguration {

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(value={ZipkinSpanExporter.class})
    static class ZipkinConfiguration {
        ZipkinConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        ZipkinSpanExporter otelZipkinSpanExporter(ZipkinProperties zipkinProperties, @Qualifier(value="zipkinSender") Sender sender) {
            return ZipkinSpanExporter.builder().setEndpoint(zipkinProperties.getBaseUrl() + "api/v2/spans").setSender(sender).setEncoder((BytesEncoder)zipkinProperties.getEncoder()).build();
        }

        @Bean
        Supplier<Resource> zipkinResourceProvider(Environment environment) {
            return () -> {
                String zipkinServiceName = environment.getProperty("spring.zipkin.service.name");
                Attributes attributes = zipkinServiceName == null ? Attributes.empty() : Attributes.of((AttributeKey)ResourceAttributes.SERVICE_NAME, (Object)zipkinServiceName);
                return Resource.create((Attributes)attributes);
            };
        }
    }
}

