/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.otel.wavefront;

import com.wavefront.spring.autoconfigure.WavefrontAutoConfiguration;
import com.wavefront.spring.autoconfigure.WavefrontSleuthSpanHandler;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collection;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cloud.sleuth.TraceContext;
import org.springframework.cloud.sleuth.otel.bridge.OtelFinishedSpan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(value={"spring.sleuth.enabled", "spring.sleuth.wavefront.enabled"}, matchIfMissing=true)
@ConditionalOnClass(value={WavefrontSleuthSpanHandler.class})
@AutoConfigureAfter(value={WavefrontAutoConfiguration.class})
public class WavefrontOtelAutoConfiguration {
    @Bean
    @ConditionalOnBean(value={WavefrontSleuthSpanHandler.class})
    SpanExporter wavefrontSpanExporter(final WavefrontSleuthSpanHandler spanHandler) {
        return new SpanExporter(){

            public CompletableResultCode export(Collection<SpanData> spans) {
                spans.forEach(spanData -> spanHandler.end(this.traceContext((SpanData)spanData), OtelFinishedSpan.fromOtel((SpanData)spanData)));
                return CompletableResultCode.ofSuccess();
            }

            private TraceContext traceContext(final SpanData spanData) {
                return new TraceContext(){

                    public String traceId() {
                        return spanData.getTraceId();
                    }

                    public String parentId() {
                        return spanData.getParentSpanId();
                    }

                    public String spanId() {
                        return spanData.getSpanId();
                    }

                    public Boolean sampled() {
                        return spanData.getSpanContext().isSampled();
                    }
                };
            }

            public CompletableResultCode flush() {
                return CompletableResultCode.ofSuccess();
            }

            public CompletableResultCode shutdown() {
                spanHandler.close();
                return CompletableResultCode.ofSuccess();
            }
        };
    }
}

