/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.otel;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.sdk.extension.resources.OsResource;
import io.opentelemetry.sdk.extension.resources.ProcessResource;
import io.opentelemetry.sdk.extension.resources.ProcessRuntimeResource;
import io.opentelemetry.sdk.resources.Resource;
import java.util.function.Supplier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.sleuth.autoconfig.otel.OtelResourceProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={OtelResourceProperties.class})
@ConditionalOnProperty(value={"spring.sleuth.otel.resource.enabled"}, matchIfMissing=true)
class OtelResourceConfiguration {
    OtelResourceConfiguration() {
    }

    @Bean
    @Conditional(value={OtelResourceAttributesCondition.class})
    Supplier<Resource> customResourceProvider(OtelResourceProperties properties) {
        AttributesBuilder attributesBuilder = Attributes.builder();
        properties.getAttributes().forEach((arg_0, arg_1) -> ((AttributesBuilder)attributesBuilder).put(arg_0, arg_1));
        return () -> Resource.create((Attributes)attributesBuilder.build());
    }

    static class OtelResourceAttributesCondition
    implements Condition {
        OtelResourceAttributesCondition() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            OtelResourceProperties config = (OtelResourceProperties)Binder.get((Environment)context.getEnvironment()).bind("spring.sleuth.otel.resource", OtelResourceProperties.class).orElse(null);
            return config != null && !config.getAttributes().isEmpty();
        }
    }

    @ConditionalOnClass(value={ProcessResource.class})
    static class OtelProcessResourceConfiguration {
        OtelProcessResourceConfiguration() {
        }

        @Bean
        Supplier<Resource> otelOsResourceProvider() {
            return OsResource::get;
        }

        @Bean
        Supplier<Resource> otelProcessResourceProvider() {
            return ProcessResource::get;
        }

        @Bean
        Supplier<Resource> otelProcessRuntimeResourceProvider() {
            return ProcessRuntimeResource::get;
        }
    }
}

