/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.otel;

import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.context.propagation.TextMapSetter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.sleuth.BaggageManager;
import org.springframework.cloud.sleuth.autoconfig.SleuthBaggageProperties;
import org.springframework.cloud.sleuth.autoconfig.otel.OtelPropagationProperties;
import org.springframework.cloud.sleuth.autoconfig.otel.SleuthPropagationProperties;
import org.springframework.cloud.sleuth.otel.bridge.BaggageTaggingSpanProcessor;
import org.springframework.cloud.sleuth.otel.propagation.BaggageTextMapPropagator;
import org.springframework.cloud.sleuth.otel.propagation.CompositeTextMapPropagator;
import org.springframework.cloud.sleuth.otel.propagation.PropagationType;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.lang.Nullable;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={SleuthPropagationProperties.class, OtelPropagationProperties.class})
class OtelPropagationConfiguration {
    OtelPropagationConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    ContextPropagators otelContextPropagators(ObjectProvider<List<TextMapPropagator>> propagators) {
        List mapPropagators = (List)propagators.getIfAvailable(ArrayList::new);
        if (mapPropagators.isEmpty()) {
            return this.noOpContextPropagator();
        }
        return ContextPropagators.create((TextMapPropagator)TextMapPropagator.composite((Iterable)mapPropagators));
    }

    private ContextPropagators noOpContextPropagator() {
        return () -> new TextMapPropagator(){

            public List<String> fields() {
                return Collections.emptyList();
            }

            public <C> void inject(Context context, @Nullable C carrier, TextMapSetter<C> setter) {
            }

            public <C> Context extract(Context context, @Nullable C carrier, TextMapGetter<C> getter) {
                return context;
            }
        };
    }

    static class B3PresentOrPropertyEnabledCondition
    implements Condition {
        B3PresentOrPropertyEnabledCondition() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            String type = context.getEnvironment().getProperty("spring.sleuth.propagation.type", PropagationType.B3.toString()).toLowerCase();
            boolean sleuthBaggageEnabled = (Boolean)context.getEnvironment().getProperty("spring.sleuth.otel.propagation.sleuth-baggage.enabled", Boolean.class, (Object)false);
            return type.contains(PropagationType.B3.toString().toLowerCase()) || sleuthBaggageEnabled;
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(name={"spring.sleuth.baggage.tag-fields"})
    static class BaggageTaggingConfiguration {
        BaggageTaggingConfiguration() {
        }

        @Bean
        BaggageTaggingSpanProcessor baggageTaggingSpanProcessor(SleuthBaggageProperties properties) {
            return new BaggageTaggingSpanProcessor(properties.getTagFields());
        }
    }

    @Configuration(proxyBeanMethods=false)
    @Conditional(value={B3PresentOrPropertyEnabledCondition.class})
    static class BaggagePropagatorConfiguration {
        BaggagePropagatorConfiguration() {
        }

        @Bean
        TextMapPropagator baggageTextMapPropagator(SleuthBaggageProperties properties, BaggageManager baggageManager) {
            return new BaggageTextMapPropagator(properties.getRemoteFields(), baggageManager);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnProperty(name={"spring.sleuth.otel.propagation.composite-text-map-propagator.enabled"}, matchIfMissing=true)
    static class PropagatorsConfiguration {
        PropagatorsConfiguration() {
        }

        @Bean
        TextMapPropagator compositeTextMapPropagator(BeanFactory beanFactory, SleuthPropagationProperties properties) {
            return new CompositeTextMapPropagator(beanFactory, properties.getType());
        }
    }
}

