/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.batch;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.StepExecutionListener;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.SpanAndScope;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.docs.TagKey;
import org.springframework.cloud.sleuth.instrument.batch.SleuthBatchSpan;

class TraceStepExecutionListener
implements StepExecutionListener {
    private final Tracer tracer;
    private static final Map<StepExecution, SpanAndScope> SPANS = new ConcurrentHashMap<StepExecution, SpanAndScope>();

    TraceStepExecutionListener(Tracer tracer) {
        this.tracer = tracer;
    }

    public void beforeStep(StepExecution stepExecution) {
        AssertingSpan span = SleuthBatchSpan.BATCH_STEP_SPAN.wrap(this.tracer.nextSpan()).name(stepExecution.getStepName());
        Tracer.SpanInScope spanInScope = this.tracer.withSpan(span.start());
        SPANS.put(stepExecution, new SpanAndScope((Span)span, spanInScope));
    }

    public ExitStatus afterStep(StepExecution stepExecution) {
        SpanAndScope spanAndScope = SPANS.remove(stepExecution);
        List throwables = stepExecution.getFailureExceptions();
        AssertingSpan span = SleuthBatchSpan.BATCH_STEP_SPAN.wrap(spanAndScope.getSpan()).tag((TagKey)SleuthBatchSpan.StepTags.STEP_NAME, stepExecution.getStepName()).tag((TagKey)SleuthBatchSpan.StepTags.JOB_EXECUTION_ID, String.valueOf(stepExecution.getJobExecutionId())).tag((TagKey)SleuthBatchSpan.StepTags.STEP_EXECUTION_ID, String.valueOf(stepExecution.getId())).tag((TagKey)SleuthBatchSpan.StepTags.STEP_TYPE, stepExecution.getExecutionContext().getString("batch.stepType"));
        Tracer.SpanInScope scope = spanAndScope.getScope();
        if (!throwables.isEmpty()) {
            span.error((Throwable)this.mergedThrowables(throwables));
        }
        span.end();
        scope.close();
        return stepExecution.getExitStatus();
    }

    private IllegalStateException mergedThrowables(List<Throwable> throwables) {
        return new IllegalStateException(throwables.stream().map(Throwable::toString).collect(Collectors.joining("\n")));
    }
}

