/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.r2dbc;

import io.r2dbc.proxy.core.QueryExecutionInfo;
import io.r2dbc.proxy.core.QueryInfo;
import io.r2dbc.proxy.listener.ProxyExecutionListener;
import io.r2dbc.spi.ConnectionFactory;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.boot.autoconfigure.r2dbc.R2dbcProperties;
import org.springframework.cloud.sleuth.Span;
import org.springframework.cloud.sleuth.Tracer;
import org.springframework.cloud.sleuth.docs.AssertingSpan;
import org.springframework.cloud.sleuth.docs.AssertingSpanBuilder;
import org.springframework.cloud.sleuth.docs.DocumentedSpan;
import org.springframework.cloud.sleuth.docs.EventValue;
import org.springframework.cloud.sleuth.docs.TagKey;
import org.springframework.cloud.sleuth.instrument.r2dbc.SleuthR2dbcSpan;
import org.springframework.cloud.sleuth.internal.ContextUtil;
import org.springframework.util.StringUtils;

public class TraceProxyExecutionListener
implements ProxyExecutionListener {
    private static final Log log = LogFactory.getLog(TraceProxyExecutionListener.class);
    private final BeanFactory beanFactory;
    private final ConnectionFactory connectionFactory;
    private Tracer tracer;

    public TraceProxyExecutionListener(BeanFactory beanFactory, ConnectionFactory connectionFactory) {
        this.beanFactory = beanFactory;
        this.connectionFactory = connectionFactory;
    }

    public void beforeQuery(QueryExecutionInfo executionInfo) {
        if (this.isContextUnusable()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Context is not ready - won't do anything");
            }
            return;
        }
        if (this.tracer().currentSpan() == null) {
            return;
        }
        String name = this.connectionFactory.getMetadata().getName();
        AssertingSpan span = this.clientSpan(executionInfo, name);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Created a new child span before query [" + span + "]"));
        }
        this.tagQueries(executionInfo, span);
        executionInfo.getValueStore().put(Span.class, (Object)span);
    }

    AssertingSpan clientSpan(QueryExecutionInfo executionInfo, String name) {
        AssertingSpanBuilder builder;
        block3: {
            R2dbcProperties r2dbcProperties = (R2dbcProperties)this.beanFactory.getBean(R2dbcProperties.class);
            String url = r2dbcProperties.getUrl();
            builder = AssertingSpanBuilder.of((DocumentedSpan)SleuthR2dbcSpan.R2DBC_QUERY_SPAN, (Span.Builder)this.tracer.spanBuilder()).kind(Span.Kind.CLIENT).name(SleuthR2dbcSpan.R2DBC_QUERY_SPAN.getName()).remoteServiceName(name).tag((TagKey)SleuthR2dbcSpan.Tags.CONNECTION, name).tag((TagKey)SleuthR2dbcSpan.Tags.THREAD, executionInfo.getThreadName());
            if (StringUtils.hasText((String)url)) {
                try {
                    URI uri = URI.create(url);
                    builder.remoteIpAndPort(uri.getHost(), uri.getPort());
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block3;
                    log.debug((Object)("Failed to parse the url [" + url + "]. Won't set this value as atag"));
                }
            }
        }
        return builder.start();
    }

    private void tagQueries(QueryExecutionInfo executionInfo, AssertingSpan span) {
        int i = 0;
        for (QueryInfo queryInfo : executionInfo.getQueries()) {
            span.tag(String.format(SleuthR2dbcSpan.Tags.QUERY.getKey(), i), queryInfo.getQuery());
            ++i;
        }
    }

    public void afterQuery(QueryExecutionInfo executionInfo) {
        if (this.isContextUnusable()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Context is not ready - won't do anything");
            }
            return;
        }
        Span span = (Span)executionInfo.getValueStore().get(Span.class, Span.class);
        if (span != null) {
            Throwable throwable;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Continued the child span in after query [" + span + "]"));
            }
            if ((throwable = executionInfo.getThrowable()) != null) {
                span.error(throwable);
            }
            span.end();
        }
    }

    public void eachQueryResult(QueryExecutionInfo executionInfo) {
        if (this.isContextUnusable()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Context is not ready - won't do anything");
            }
            return;
        }
        Span span = (Span)executionInfo.getValueStore().get(Span.class, Span.class);
        if (span != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Marking after query result for span [" + span + "]"));
            }
            SleuthR2dbcSpan.R2DBC_QUERY_SPAN.wrap(span).event((EventValue)SleuthR2dbcSpan.Events.QUERY_RESULT);
        }
    }

    boolean isContextUnusable() {
        return ContextUtil.isContextUnusable(this.beanFactory);
    }

    private Tracer tracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)this.beanFactory.getBean(Tracer.class);
        }
        return this.tracer;
    }
}

