/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.instrument.web.client.feign;

import feign.Client;
import feign.Feign;
import java.lang.reflect.Field;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.cloud.sleuth.instrument.web.client.feign.LazyClient;
import org.springframework.cloud.sleuth.instrument.web.client.feign.LazyTracingFeignClient;
import org.springframework.util.ReflectionUtils;

public class TraceFeignBuilderBeanPostProcessor
implements BeanPostProcessor {
    private final BeanFactory beanFactory;

    public TraceFeignBuilderBeanPostProcessor(BeanFactory beanFactory) {
        this.beanFactory = beanFactory;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof Feign.Builder) {
            Field client = ReflectionUtils.findField(Feign.Builder.class, (String)"client");
            ReflectionUtils.makeAccessible((Field)client);
            Feign.Builder delegate = (Feign.Builder)bean;
            Client clientInDelegate = (Client)ReflectionUtils.getField((Field)client, (Object)delegate);
            if (clientInDelegate instanceof LazyClient || clientInDelegate instanceof LazyTracingFeignClient) {
                return bean;
            }
            delegate.client((Client)new LazyClient(this.beanFactory, clientInDelegate));
            return bean;
        }
        return bean;
    }
}

