/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.sleuth.autoconfig.actuate;

import java.util.List;
import org.springframework.boot.actuate.endpoint.Producible;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.boot.actuate.endpoint.annotation.WriteOperation;
import org.springframework.boot.actuate.endpoint.web.WebEndpointResponse;
import org.springframework.boot.actuate.endpoint.web.annotation.WebEndpoint;
import org.springframework.cloud.sleuth.autoconfig.actuate.BufferingSpanReporter;
import org.springframework.cloud.sleuth.autoconfig.actuate.FinishedSpanWriter;
import org.springframework.cloud.sleuth.autoconfig.actuate.TextOutputFormat;
import org.springframework.cloud.sleuth.exporter.FinishedSpan;
import org.springframework.http.HttpStatus;
import org.springframework.lang.NonNull;

@WebEndpoint(id="traces")
public class TracesScrapeEndpoint {
    private final BufferingSpanReporter bufferingSpanReporter;
    private final FinishedSpanWriter finishedSpanWriter;

    public TracesScrapeEndpoint(BufferingSpanReporter bufferingSpanReporter, FinishedSpanWriter finishedSpanWriter) {
        this.bufferingSpanReporter = bufferingSpanReporter;
        this.finishedSpanWriter = finishedSpanWriter;
    }

    @ReadOperation(producesFrom=TextOutputFormat.class)
    public WebEndpointResponse<Object> spansSnapshot(TextOutputFormat format) {
        List<FinishedSpan> finishedSpans = this.bufferingSpanReporter.getFinishedSpans();
        return this.response(format, finishedSpans);
    }

    @NonNull
    private WebEndpointResponse<Object> response(TextOutputFormat format, List<FinishedSpan> finishedSpans) {
        Object spans = this.finishedSpanWriter.write(format, finishedSpans);
        if (spans == null) {
            return new WebEndpointResponse((Object)("The format [" + format.getProducedMimeType() + " ] is not supported"), HttpStatus.NOT_ACCEPTABLE.value());
        }
        return new WebEndpointResponse(spans, (Producible)format);
    }

    @WriteOperation(producesFrom=TextOutputFormat.class)
    public WebEndpointResponse<Object> spans(TextOutputFormat format) {
        List<FinishedSpan> finishedSpans = this.bufferingSpanReporter.drainFinishedSpans();
        return this.response(format, finishedSpans);
    }
}

