/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.kubernetes.commons.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.cloud.kubernetes.commons.config.ConfigUtils;
import org.springframework.cloud.kubernetes.commons.config.LabeledSecretNormalizedSource;
import org.springframework.cloud.kubernetes.commons.config.NamedSecretNormalizedSource;
import org.springframework.cloud.kubernetes.commons.config.NormalizedSource;
import org.springframework.cloud.kubernetes.commons.config.RetryProperties;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

@ConfigurationProperties(value="spring.cloud.kubernetes.secrets")
public record SecretsConfigProperties(boolean enableApi, Map<String, String> labels, List<String> paths, List<Source> sources, boolean enabled, String name, String namespace, boolean useNameAsPrefix, boolean includeProfileSpecificSources, boolean failFast, RetryProperties retry) {
    public static final String PREFIX = "spring.cloud.kubernetes.secrets";

    public List<NormalizedSource> determineSources(Environment environment) {
        if (this.sources.isEmpty()) {
            ArrayList<NormalizedSource> result = new ArrayList<NormalizedSource>(2);
            String name = ConfigUtils.getApplicationName(environment, this.name, "Secret");
            result.add(new NamedSecretNormalizedSource(name, this.namespace, this.failFast, this.includeProfileSpecificSources));
            if (!this.labels.isEmpty()) {
                result.add(new LabeledSecretNormalizedSource(this.namespace, this.labels, this.failFast, ConfigUtils.Prefix.DEFAULT, false));
            }
            return result;
        }
        return this.sources.stream().flatMap(s -> s.normalize(this.name, this.namespace, this.labels, this.includeProfileSpecificSources, this.failFast, this.useNameAsPrefix, environment)).toList();
    }

    public record Source(String name, String namespace, Map<String, String> labels, String explicitPrefix, Boolean useNameAsPrefix, Boolean includeProfileSpecificSources) {
        private Stream<NormalizedSource> normalize(String defaultName, String defaultNamespace, Map<String, String> defaultLabels, boolean defaultIncludeProfileSpecificSources, boolean failFast, boolean defaultUseNameAsPrefix, Environment environment) {
            Stream.Builder<NormalizedSource> normalizedSources = Stream.builder();
            String normalizedName = StringUtils.hasLength((String)this.name) ? this.name : defaultName;
            String normalizedNamespace = StringUtils.hasLength((String)this.namespace) ? this.namespace : defaultNamespace;
            Map<String, String> normalizedLabels = this.labels.isEmpty() ? defaultLabels : this.labels;
            String secretName = ConfigUtils.getApplicationName(environment, normalizedName, "Secret");
            ConfigUtils.Prefix prefix = ConfigUtils.findPrefix(this.explicitPrefix, this.useNameAsPrefix, defaultUseNameAsPrefix, normalizedName);
            boolean includeProfileSpecificSources = ConfigUtils.includeProfileSpecificSources(defaultIncludeProfileSpecificSources, this.includeProfileSpecificSources);
            NamedSecretNormalizedSource namedBasedSource = new NamedSecretNormalizedSource(secretName, normalizedNamespace, failFast, prefix, includeProfileSpecificSources);
            normalizedSources.add(namedBasedSource);
            if (!normalizedLabels.isEmpty()) {
                LabeledSecretNormalizedSource labeledBasedSource = new LabeledSecretNormalizedSource(normalizedNamespace, this.labels, failFast, prefix, includeProfileSpecificSources);
                normalizedSources.add(labeledBasedSource);
            }
            return normalizedSources.build();
        }
    }
}

