/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory.cache.keygenerator;

import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.cloud.gateway.filter.factory.cache.keygenerator.KeyValueGenerator;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;

class CookiesKeyValueGenerator
implements KeyValueGenerator {
    private final String valueSeparator;

    CookiesKeyValueGenerator(String valueSeparator) {
        this.valueSeparator = Objects.requireNonNull(valueSeparator);
    }

    @Override
    public String getKeyValue(ServerHttpRequest request) {
        String cookiesData = null;
        MultiValueMap cookies = request.getCookies();
        if (!CollectionUtils.isEmpty((Map)cookies)) {
            cookiesData = cookies.values().stream().flatMap(Collection::stream).map(c -> String.format("%s=%s", c.getName(), c.getValue())).sorted().collect(Collectors.joining(this.valueSeparator));
        }
        return cookiesData;
    }
}

