/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.invoke.reflect;

import java.lang.reflect.Method;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.cloud.gateway.server.mvc.invoke.InvocationContext;
import org.springframework.cloud.gateway.server.mvc.invoke.MissingParametersException;
import org.springframework.cloud.gateway.server.mvc.invoke.OperationInvoker;
import org.springframework.cloud.gateway.server.mvc.invoke.OperationParameter;
import org.springframework.cloud.gateway.server.mvc.invoke.ParameterValueMapper;
import org.springframework.cloud.gateway.server.mvc.invoke.reflect.OperationMethod;
import org.springframework.core.style.ToStringCreator;
import org.springframework.util.ReflectionUtils;

public class ReflectiveOperationInvoker
implements OperationInvoker {
    private final @Nullable Object target;
    private final OperationMethod operationMethod;
    private final ParameterValueMapper parameterValueMapper;

    public ReflectiveOperationInvoker(OperationMethod operationMethod, ParameterValueMapper parameterValueMapper) {
        this(null, operationMethod, parameterValueMapper);
    }

    public ReflectiveOperationInvoker(@Nullable Object target, OperationMethod operationMethod, ParameterValueMapper parameterValueMapper) {
        Objects.requireNonNull(operationMethod, "OperationMethod must not be null");
        Objects.requireNonNull(parameterValueMapper, "ParameterValueMapper must not be null");
        ReflectionUtils.makeAccessible((Method)operationMethod.getMethod());
        this.target = target;
        this.operationMethod = operationMethod;
        this.parameterValueMapper = parameterValueMapper;
    }

    @Override
    public <T> T invoke(InvocationContext context) {
        this.validateRequiredParameters(context);
        Method method = this.operationMethod.getMethod();
        Object[] resolvedArguments = this.resolveArguments(context);
        ReflectionUtils.makeAccessible((Method)method);
        Object result = ReflectionUtils.invokeMethod((Method)method, (Object)this.target, (Object[])resolvedArguments);
        Objects.requireNonNull(result, "Operation method returned null");
        return (T)result;
    }

    private void validateRequiredParameters(InvocationContext context) {
        Set<OperationParameter> missing = this.operationMethod.getParameters().stream().filter(parameter -> this.isMissing(context, (OperationParameter)parameter)).collect(Collectors.toSet());
        if (!missing.isEmpty()) {
            throw new MissingParametersException(missing);
        }
    }

    private boolean isMissing(InvocationContext context, OperationParameter parameter) {
        if (!parameter.isMandatory()) {
            return false;
        }
        if (context.canResolve(parameter.getType())) {
            return false;
        }
        return context.getArguments().get(parameter.getName()) == null;
    }

    private Object[] resolveArguments(InvocationContext context) {
        return this.operationMethod.getParameters().stream().map(parameter -> this.resolveArgument((OperationParameter)parameter, context)).toArray();
    }

    private Object resolveArgument(OperationParameter parameter, InvocationContext context) {
        Object resolvedByType = context.resolveArgument(parameter.getType());
        if (resolvedByType != null) {
            return resolvedByType;
        }
        Object value = context.getArguments().get(parameter.getName());
        Objects.requireNonNull(value, "Missing value for parameter " + parameter.getName());
        return this.parameterValueMapper.mapParameterValue(parameter, value);
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("target", this.target).append("method", (Object)this.operationMethod).toString();
    }
}

