/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.handler;

import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.function.RouterFunctions;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;

abstract class GatewayErrorHandlingServerResponse
implements ServerResponse {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private final List<ErrorHandler<?>> errorHandlers = new ArrayList();

    GatewayErrorHandlingServerResponse() {
    }

    protected final <T extends ServerResponse> void addErrorHandler(Predicate<Throwable> predicate, BiFunction<Throwable, ServerRequest, T> errorHandler) {
        Objects.requireNonNull(predicate, "Predicate must not be null");
        Objects.requireNonNull(errorHandler, "ErrorHandler must not be null");
        this.errorHandlers.add(new ErrorHandler<T>(predicate, errorHandler));
    }

    protected final @Nullable ModelAndView handleError(Throwable t, HttpServletRequest servletRequest, HttpServletResponse servletResponse, ServerResponse.Context context) throws ServletException, IOException {
        ServerResponse serverResponse = this.errorResponse(t, servletRequest);
        if (serverResponse != null) {
            return serverResponse.writeTo(servletRequest, servletResponse, context);
        }
        if (t instanceof ServletException) {
            ServletException servletException = (ServletException)t;
            throw servletException;
        }
        if (t instanceof IOException) {
            IOException ioException = (IOException)t;
            throw ioException;
        }
        throw new ServletException(t);
    }

    protected final @Nullable ServerResponse errorResponse(Throwable t, HttpServletRequest servletRequest) {
        for (ErrorHandler<?> errorHandler : this.errorHandlers) {
            if (!errorHandler.test(t)) continue;
            ServerRequest serverRequest = (ServerRequest)servletRequest.getAttribute(RouterFunctions.REQUEST_ATTRIBUTE);
            return errorHandler.handle(t, serverRequest);
        }
        return null;
    }

    private static class ErrorHandler<T extends ServerResponse> {
        private final Predicate<Throwable> predicate;
        private final BiFunction<Throwable, ServerRequest, T> responseProvider;

        ErrorHandler(Predicate<Throwable> predicate, BiFunction<Throwable, ServerRequest, T> responseProvider) {
            Objects.requireNonNull(predicate, "Predicate must not be null");
            Objects.requireNonNull(responseProvider, "ResponseProvider must not be null");
            this.predicate = predicate;
            this.responseProvider = responseProvider;
        }

        public boolean test(Throwable t) {
            return this.predicate.test(t);
        }

        public T handle(Throwable t, ServerRequest serverRequest) {
            return (T)((ServerResponse)this.responseProvider.apply(t, serverRequest));
        }
    }
}

