/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.filter;

import java.io.IOException;
import java.util.function.Consumer;
import org.springframework.cloud.gateway.server.mvc.common.MvcUtils;
import org.springframework.cloud.gateway.server.mvc.filter.RetryFilterFunctions;
import org.springframework.core.retry.RetryPolicy;
import org.springframework.core.retry.RetryTemplate;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.servlet.function.HandlerFilterFunction;
import org.springframework.web.servlet.function.ServerRequest;
import org.springframework.web.servlet.function.ServerResponse;

@Deprecated
public abstract class FrameworkRetryFilterFunctions {
    private FrameworkRetryFilterFunctions() {
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> frameworkRetry(int retries) {
        return FrameworkRetryFilterFunctions.frameworkRetry((RetryFilterFunctions.RetryConfig config) -> config.setRetries(retries));
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> frameworkRetry(Consumer<RetryFilterFunctions.RetryConfig> configConsumer) {
        RetryFilterFunctions.RetryConfig config = new RetryFilterFunctions.RetryConfig();
        configConsumer.accept(config);
        return FrameworkRetryFilterFunctions.frameworkRetry(config);
    }

    public static HandlerFilterFunction<ServerResponse, ServerResponse> frameworkRetry(RetryFilterFunctions.RetryConfig config) {
        return (request, next) -> {
            CompositeRetryPolicy compositeRetryPolicy = new CompositeRetryPolicy(config);
            RetryTemplate retryTemplate = new RetryTemplate();
            retryTemplate.setRetryPolicy((RetryPolicy)compositeRetryPolicy);
            return (ServerResponse)retryTemplate.execute(() -> {
                if (config.isCacheBody()) {
                    MvcUtils.getOrCacheBody(request);
                }
                FrameworkRetryFilterFunctions.reset(request);
                ServerResponse serverResponse = next.handle(request);
                if (FrameworkRetryFilterFunctions.isRetryableStatusCode(serverResponse.statusCode(), config) && FrameworkRetryFilterFunctions.isRetryableMethod(request.method(), config)) {
                    throw new RetryFilterFunctions.RetryException(request, serverResponse);
                }
                return serverResponse;
            });
        };
    }

    private static void reset(ServerRequest request) throws IOException {
        ClientHttpResponse clientHttpResponse = (ClientHttpResponse)MvcUtils.getAttribute(request, MvcUtils.CLIENT_RESPONSE_ATTR);
        if (clientHttpResponse != null) {
            clientHttpResponse.close();
            MvcUtils.putAttribute(request, MvcUtils.CLIENT_RESPONSE_ATTR, null);
        }
    }

    private static boolean isRetryableStatusCode(HttpStatusCode httpStatus, RetryFilterFunctions.RetryConfig config) {
        return config.getSeries().stream().anyMatch(series -> HttpStatus.Series.resolve((int)httpStatus.value()) == series);
    }

    private static boolean isRetryableMethod(HttpMethod method, RetryFilterFunctions.RetryConfig config) {
        return config.getMethods().contains(method);
    }

    private static class CompositeRetryPolicy
    implements RetryPolicy {
        private final RetryFilterFunctions.RetryConfig config;
        private int attemptCount = 0;

        CompositeRetryPolicy(RetryFilterFunctions.RetryConfig config) {
            this.config = config;
        }

        public boolean shouldRetry(Throwable throwable) {
            RetryFilterFunctions.RetryException retryException;
            if (throwable == null) {
                return false;
            }
            if (this.attemptCount >= this.config.getRetries()) {
                return false;
            }
            boolean shouldRetry = false;
            shouldRetry = throwable instanceof RetryFilterFunctions.RetryException ? FrameworkRetryFilterFunctions.isRetryableStatusCode((retryException = (RetryFilterFunctions.RetryException)((Object)throwable)).getResponse().statusCode(), this.config) && FrameworkRetryFilterFunctions.isRetryableMethod(retryException.getRequest().method(), this.config) : this.config.getExceptions().stream().anyMatch(exceptionClass -> exceptionClass.isInstance(throwable));
            if (shouldRetry) {
                ++this.attemptCount;
                return true;
            }
            return false;
        }
    }
}

