/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jspecify.annotations.Nullable;
import org.springframework.aot.hint.MemberCategory;
import org.springframework.aot.hint.ReflectionHints;
import org.springframework.aot.hint.TypeReference;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotContribution;
import org.springframework.beans.factory.aot.BeanFactoryInitializationAotProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.cloud.gateway.server.mvc.config.FilterProperties;
import org.springframework.cloud.gateway.server.mvc.config.PredicateProperties;
import org.springframework.cloud.gateway.server.mvc.config.RouteProperties;
import org.springframework.cloud.gateway.server.mvc.filter.FilterAutoConfiguration;
import org.springframework.cloud.gateway.server.mvc.filter.FilterFunctions;
import org.springframework.cloud.gateway.server.mvc.predicate.PredicateAutoConfiguration;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.ResolvableType;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class GatewayMvcRuntimeHintsProcessor
implements BeanFactoryInitializationAotProcessor {
    private static final Log LOG = LogFactory.getLog(GatewayMvcRuntimeHintsProcessor.class);
    private static final String GATEWAY_MVC_FILTER_PACKAGE_NAME = "org.springframework.cloud.gateway.server.mvc.filter";
    private static final String GATEWAY_MVC_PREDICATE_PACKAGE_NAME = "org.springframework.cloud.gateway.server.mvc.predicate";
    private static final Map<String, Set<String>> beansConditionalOnClasses = Map.of("io.github.bucket4j.BucketConfiguration", Set.of("org.springframework.cloud.gateway.server.mvc.filter.Bucket4jFilterFunctions"), "org.springframework.cloud.client.circuitbreaker.CircuitBreaker", Set.of("org.springframework.cloud.gateway.server.mvc.filter.CircuitBreakerFilterFunctions"), "org.springframework.cloud.loadbalancer.annotation.LoadBalancerClient", Set.of("org.springframework.cloud.gateway.server.mvc.filter.LoadBalancerFilterFunctions"), "org.springframework.retry.support.RetryTemplate", Set.of("org.springframework.cloud.gateway.server.mvc.filter.RetryFilterFunctions"), "org.springframework.security.oauth2.client.OAuth2AuthorizedClient", Set.of("org.springframework.cloud.gateway.server.mvc.filter.TokenRelayFilterFunctions"));
    private static final Set<Class<?>> PROPERTIES = Set.of(FilterProperties.class, PredicateProperties.class, RouteProperties.class);

    public BeanFactoryInitializationAotContribution processAheadOfTime(ConfigurableListableBeanFactory beanFactory) {
        return (generationContext, beanFactoryInitializationCode) -> {
            ReflectionHints hints = generationContext.getRuntimeHints().reflection();
            Set<Class> typesToRegister = Stream.of(GatewayMvcRuntimeHintsProcessor.getTypesToRegister(GATEWAY_MVC_FILTER_PACKAGE_NAME), GatewayMvcRuntimeHintsProcessor.getTypesToRegister(GATEWAY_MVC_PREDICATE_PACKAGE_NAME), PROPERTIES, new HashSet<Class<FilterFunctions>>(Collections.singletonList(FilterFunctions.class))).flatMap(Collection::stream).collect(Collectors.toSet());
            typesToRegister.forEach(clazz -> hints.registerType(TypeReference.of((Class)clazz), hint -> hint.withMembers(new MemberCategory[]{MemberCategory.DECLARED_FIELDS, MemberCategory.INVOKE_DECLARED_METHODS, MemberCategory.INVOKE_DECLARED_CONSTRUCTORS})));
        };
    }

    private static Set<Class<?>> getTypesToRegister(String packageName) {
        Set<Class<?>> classesToAdd = GatewayMvcRuntimeHintsProcessor.getClassesToAdd(packageName);
        HashSet genericsToAdd = new HashSet();
        HashSet superTypes = new HashSet();
        HashSet enclosingClasses = new HashSet();
        for (Class<?> clazz : classesToAdd) {
            ResolvableType resolvableType = ResolvableType.forType(clazz);
            GatewayMvcRuntimeHintsProcessor.addGenericsForClass(genericsToAdd, resolvableType);
            GatewayMvcRuntimeHintsProcessor.addSuperTypesForClass(resolvableType, superTypes, genericsToAdd);
            GatewayMvcRuntimeHintsProcessor.addEnclosingClassesForClass(enclosingClasses, resolvableType.getRawClass());
        }
        classesToAdd.addAll(genericsToAdd);
        classesToAdd.addAll(superTypes);
        classesToAdd.addAll(enclosingClasses);
        return classesToAdd.stream().filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private static void addEnclosingClassesForClass(Set<Class<?>> enclosingClasses, @Nullable Class<?> clazz) {
        if (clazz == null) {
            return;
        }
        Class<?> enclosing = clazz.getEnclosingClass();
        if (enclosing != null) {
            enclosingClasses.add(enclosing);
            GatewayMvcRuntimeHintsProcessor.addEnclosingClassesForClass(enclosingClasses, enclosing);
        }
    }

    private static Set<Class<?>> getClassesToAdd(String packageName) {
        HashSet classesToAdd = new HashSet();
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(Object.class));
        provider.addExcludeFilter((TypeFilter)new AssignableTypeFilter(FilterAutoConfiguration.class));
        provider.addExcludeFilter((TypeFilter)new AssignableTypeFilter(PredicateAutoConfiguration.class));
        Set components = provider.findCandidateComponents(packageName);
        for (BeanDefinition component : components) {
            try {
                Class<?> clazz = Class.forName(component.getBeanClassName());
                if (!GatewayMvcRuntimeHintsProcessor.shouldRegisterClass(clazz)) continue;
                classesToAdd.add(clazz);
            }
            catch (ClassNotFoundException | NoClassDefFoundError exception) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug((Object)exception);
            }
        }
        return classesToAdd;
    }

    private static void addGenericsForClass(Set<Class<?>> genericsToAdd, ResolvableType resolvableType) {
        if (resolvableType.getSuperType().hasGenerics()) {
            genericsToAdd.addAll(Arrays.stream(resolvableType.getSuperType().getGenerics()).map(ResolvableType::toClass).collect(Collectors.toSet()));
        }
    }

    private static void addSuperTypesForClass(ResolvableType resolvableType, Set<Class<?>> supertypesToAdd, Set<Class<?>> genericsToAdd) {
        ResolvableType superType = resolvableType.getSuperType();
        if (!ResolvableType.NONE.equals((Object)superType)) {
            GatewayMvcRuntimeHintsProcessor.addGenericsForClass(genericsToAdd, superType);
            supertypesToAdd.add(superType.toClass());
            GatewayMvcRuntimeHintsProcessor.addSuperTypesForClass(superType, supertypesToAdd, genericsToAdd);
        }
    }

    private static boolean shouldRegisterClass(Class<?> clazz) {
        Set conditionClasses = beansConditionalOnClasses.getOrDefault(clazz.getName(), Collections.emptySet());
        for (String conditionClass : conditionClasses) {
            try {
                GatewayMvcRuntimeHintsProcessor.class.getClassLoader().loadClass(conditionClass);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
        return true;
    }
}

