/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter.factory;

import java.net.MalformedURLException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.GatewayFilter;
import org.springframework.cloud.gateway.filter.OrderedGatewayFilter;
import org.springframework.cloud.gateway.filter.factory.AbstractChangeRequestUriGatewayFilterFactory;
import org.springframework.cloud.gateway.filter.factory.AbstractGatewayFilterFactory;
import org.springframework.cloud.gateway.support.GatewayToStringStyler;
import org.springframework.web.server.ServerWebExchange;

public class RequestHeaderToRequestUriGatewayFilterFactory
extends AbstractChangeRequestUriGatewayFilterFactory<AbstractGatewayFilterFactory.NameConfig> {
    private final Logger log = LoggerFactory.getLogger(RequestHeaderToRequestUriGatewayFilterFactory.class);

    public RequestHeaderToRequestUriGatewayFilterFactory() {
        super(AbstractGatewayFilterFactory.NameConfig.class);
    }

    @Override
    public List<String> shortcutFieldOrder() {
        return Arrays.asList("name");
    }

    @Override
    public GatewayFilter apply(final AbstractGatewayFilterFactory.NameConfig config) {
        OrderedGatewayFilter gatewayFilter = (OrderedGatewayFilter)super.apply(config);
        return new OrderedGatewayFilter(this, gatewayFilter, gatewayFilter.getOrder()){
            final /* synthetic */ RequestHeaderToRequestUriGatewayFilterFactory this$0;
            {
                this.this$0 = this$0;
                super(delegate, order);
            }

            @Override
            public String toString() {
                return GatewayToStringStyler.filterToStringCreator(this.this$0).append("name", (Object)config.getName()).toString();
            }
        };
    }

    @Override
    protected Optional<URI> determineRequestUri(ServerWebExchange exchange, AbstractGatewayFilterFactory.NameConfig config) {
        String requestUrl = exchange.getRequest().getHeaders().getFirst(config.getName());
        return Optional.ofNullable(requestUrl).map(url -> {
            try {
                URI uri = URI.create(url);
                uri.toURL();
                return uri;
            }
            catch (IllegalArgumentException | MalformedURLException e) {
                this.log.info("Request url is invalid : url={}, error={}", (Object)requestUrl, (Object)e.getMessage());
                return null;
            }
        });
    }
}

