/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.filter;

import io.netty.buffer.ByteBuf;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.cloud.gateway.filter.headers.TrailerHeadersFilter;
import org.springframework.cloud.gateway.support.ServerWebExchangeUtils;
import org.springframework.core.Ordered;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.core.io.buffer.DefaultDataBuffer;
import org.springframework.core.io.buffer.DefaultDataBufferFactory;
import org.springframework.core.io.buffer.NettyDataBufferFactory;
import org.springframework.http.MediaType;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.netty.Connection;
import reactor.netty.http.client.HttpClientResponse;

public class NettyWriteResponseFilter
implements GlobalFilter,
Ordered {
    public static final int WRITE_RESPONSE_FILTER_ORDER = -1;
    private static final Log log = LogFactory.getLog(NettyWriteResponseFilter.class);
    private final List<MediaType> streamingMediaTypes;
    private final ObjectProvider<List<HttpHeadersFilter>> headersFiltersProvider;
    private volatile List<HttpHeadersFilter> headersFilters;

    public NettyWriteResponseFilter(List<MediaType> streamingMediaTypes, ObjectProvider<List<HttpHeadersFilter>> headersFiltersProvider) {
        this.streamingMediaTypes = streamingMediaTypes;
        this.headersFiltersProvider = headersFiltersProvider;
    }

    public List<HttpHeadersFilter> getHeadersFilters() {
        if (this.headersFilters == null) {
            this.headersFilters = this.headersFiltersProvider == null ? List.of() : (List)this.headersFiltersProvider.getIfAvailable();
        }
        return this.headersFilters;
    }

    public int getOrder() {
        return -1;
    }

    @Override
    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        return chain.filter(exchange).then(Mono.defer(() -> {
            MediaType contentType;
            Flux body;
            ServerHttpResponse response;
            block4: {
                Connection connection = (Connection)exchange.getAttribute(ServerWebExchangeUtils.CLIENT_RESPONSE_CONN_ATTR);
                if (connection == null) {
                    return Mono.empty();
                }
                if (log.isTraceEnabled()) {
                    log.trace((Object)("NettyWriteResponseFilter start inbound: " + connection.channel().id().asShortText() + ", outbound: " + exchange.getLogPrefix()));
                }
                response = exchange.getResponse();
                body = connection.inbound().receive().retain().map(byteBuf -> this.wrap((ByteBuf)byteBuf, response));
                contentType = null;
                try {
                    contentType = response.getHeaders().getContentType();
                }
                catch (Exception e) {
                    if (!log.isTraceEnabled()) break block4;
                    log.trace((Object)"invalid media type", (Throwable)e);
                }
            }
            HttpClientResponse httpClientResponse = (HttpClientResponse)exchange.getAttribute(ServerWebExchangeUtils.CLIENT_RESPONSE_ATTR);
            Mono write = this.isStreamingMediaType(contentType) ? response.writeAndFlushWith((Publisher)body.map(Flux::just)) : response.writeWith((Publisher)body);
            return write.then(TrailerHeadersFilter.filter(this.getHeadersFilters(), exchange, httpClientResponse)).then();
        })).doFinally(signalType -> {
            if (signalType == SignalType.CANCEL || signalType == SignalType.ON_ERROR) {
                this.cleanup(exchange);
            }
        });
    }

    protected DataBuffer wrap(ByteBuf byteBuf, ServerHttpResponse response) {
        DataBufferFactory bufferFactory = response.bufferFactory();
        if (bufferFactory instanceof NettyDataBufferFactory) {
            NettyDataBufferFactory factory = (NettyDataBufferFactory)bufferFactory;
            return factory.wrap(byteBuf);
        }
        if (bufferFactory instanceof DefaultDataBufferFactory) {
            DefaultDataBuffer buffer = ((DefaultDataBufferFactory)bufferFactory).allocateBuffer(byteBuf.readableBytes());
            buffer.write(new ByteBuffer[]{byteBuf.nioBuffer()});
            byteBuf.release();
            return buffer;
        }
        throw new IllegalArgumentException("Unknown DataBufferFactory type " + String.valueOf(bufferFactory.getClass()));
    }

    private void cleanup(ServerWebExchange exchange) {
        Connection connection = (Connection)exchange.getAttribute(ServerWebExchangeUtils.CLIENT_RESPONSE_CONN_ATTR);
        if (connection != null) {
            connection.dispose();
        }
    }

    private boolean isStreamingMediaType(@Nullable MediaType contentType) {
        if (contentType != null) {
            for (int i = 0; i < this.streamingMediaTypes.size(); ++i) {
                if (!this.streamingMediaTypes.get(i).isCompatibleWith(contentType)) continue;
                return true;
            }
        }
        return false;
    }
}

