/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.server.mvc.filter;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.cloud.gateway.server.mvc.filter.HttpHeadersFilter;
import org.springframework.core.Ordered;
import org.springframework.http.HttpHeaders;
import org.springframework.web.servlet.function.ServerRequest;

public class RemoveHopByHopRequestHeadersFilter
implements HttpHeadersFilter.RequestHttpHeadersFilter,
Ordered {
    public static final Set<String> HEADERS_REMOVED_ON_REQUEST = new HashSet<String>(Arrays.asList("connection", "keep-alive", "transfer-encoding", "te", "trailer", "proxy-authorization", "proxy-authenticate", "x-application-context", "upgrade"));
    private int order = 0x7FFFFFFE;
    private Set<String> headers = HEADERS_REMOVED_ON_REQUEST;

    @Override
    public HttpHeaders apply(HttpHeaders input, ServerRequest serverRequest) {
        return RemoveHopByHopRequestHeadersFilter.filter(input, this.headers);
    }

    static HttpHeaders filter(HttpHeaders input, Set<String> headersToRemove) {
        HttpHeaders filtered = new HttpHeaders();
        for (Map.Entry entry : input.entrySet()) {
            if (headersToRemove.contains(((String)entry.getKey()).toLowerCase())) continue;
            filtered.addAll((String)entry.getKey(), (List)entry.getValue());
        }
        return filtered;
    }

    public int getOrder() {
        return this.order;
    }
}

