/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.verifier.builder;

import java.util.Arrays;
import org.springframework.cloud.contract.verifier.builder.BlockBuilder;
import org.springframework.cloud.contract.verifier.builder.ClassAnnotation;
import org.springframework.cloud.contract.verifier.builder.GeneratedClassMetaData;
import org.springframework.cloud.contract.verifier.config.TestFramework;

class JUnit5OrderClassAnnotation
implements ClassAnnotation {
    private final BlockBuilder blockBuilder;
    private final GeneratedClassMetaData generatedClassMetaData;
    private static final String[] ANNOTATIONS = new String[]{"@TestMethodOrder(MethodOrderer.MethodName.class)"};

    JUnit5OrderClassAnnotation(BlockBuilder blockBuilder, GeneratedClassMetaData generatedClassMetaData) {
        this.blockBuilder = blockBuilder;
        this.generatedClassMetaData = generatedClassMetaData;
    }

    @Override
    public ClassAnnotation call() {
        Arrays.stream(ANNOTATIONS).forEach(this.blockBuilder::addIndented);
        return this;
    }

    @Override
    public boolean accept() {
        return this.generatedClassMetaData.configProperties.getTestFramework() == TestFramework.JUNIT5 && this.generatedClassMetaData.listOfFiles.stream().anyMatch(meta -> meta.getOrder() != null);
    }
}

