/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.contract.stubrunner.spring.cloud.eureka;

import com.netflix.appinfo.ApplicationInfoManager;
import com.netflix.appinfo.EurekaInstanceConfig;
import com.netflix.appinfo.InstanceInfo;
import com.netflix.discovery.AbstractDiscoveryClientOptionalArgs;
import com.netflix.discovery.EurekaClient;
import com.netflix.discovery.EurekaClientConfig;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.cloud.client.serviceregistry.Registration;
import org.springframework.cloud.client.serviceregistry.ServiceRegistry;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.contract.stubrunner.StubConfiguration;
import org.springframework.cloud.contract.stubrunner.StubRunning;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubMapperProperties;
import org.springframework.cloud.contract.stubrunner.spring.cloud.StubsRegistrar;
import org.springframework.cloud.netflix.eureka.CloudEurekaClient;
import org.springframework.cloud.netflix.eureka.CloudEurekaInstanceConfig;
import org.springframework.cloud.netflix.eureka.EurekaClientConfigBean;
import org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean;
import org.springframework.cloud.netflix.eureka.InstanceInfoFactory;
import org.springframework.cloud.netflix.eureka.serviceregistry.EurekaRegistration;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.util.StringUtils;

public class EurekaStubsRegistrar
implements StubsRegistrar {
    private static final Log log = LogFactory.getLog(MethodHandles.lookup().lookupClass());
    private final StubRunning stubRunning;
    private final StubMapperProperties stubMapperProperties;
    private final InetUtils inetUtils;
    private final EurekaInstanceConfigBean eurekaInstanceConfigBean;
    private final EurekaClientConfigBean eurekaClientConfigBean;
    private final List<EurekaRegistration> registrations = new LinkedList<EurekaRegistration>();
    private final ServiceRegistry<EurekaRegistration> serviceRegistry;
    private final ApplicationContext context;

    public EurekaStubsRegistrar(StubRunning stubRunning, ServiceRegistry<EurekaRegistration> serviceRegistry, StubMapperProperties stubMapperProperties, InetUtils inetUtils, EurekaInstanceConfigBean eurekaInstanceConfigBean, EurekaClientConfigBean eurekaClientConfigBean, ApplicationContext context) {
        this.stubRunning = stubRunning;
        this.stubMapperProperties = stubMapperProperties;
        this.serviceRegistry = serviceRegistry;
        this.inetUtils = inetUtils;
        this.eurekaInstanceConfigBean = eurekaInstanceConfigBean;
        this.eurekaClientConfigBean = eurekaClientConfigBean;
        this.context = context;
    }

    @Override
    public void registerStubs() {
        Map<StubConfiguration, Integer> activeStubs = this.stubRunning.runStubs().validNamesAndPorts();
        for (Map.Entry<StubConfiguration, Integer> entry : activeStubs.entrySet()) {
            EurekaInstanceConfigBean instance = this.registration(entry);
            log.info((Object)("Will register stub in Eureka [" + instance.getAppname() + ", " + instance.getHostname() + ", " + instance.getNonSecurePort() + ", " + instance.getInstanceId() + "]"));
            InstanceInfo instanceInfo = new InstanceInfoFactory().create((EurekaInstanceConfig)instance);
            ApplicationInfoManager applicationInfoManager = new ApplicationInfoManager((EurekaInstanceConfig)instance, instanceInfo);
            AbstractDiscoveryClientOptionalArgs args = this.args();
            CloudEurekaClient client = new CloudEurekaClient(applicationInfoManager, (EurekaClientConfig)this.eurekaClientConfigBean, args, (ApplicationEventPublisher)this.context);
            EurekaRegistration registration = EurekaRegistration.builder((CloudEurekaInstanceConfig)instance).with((EurekaClientConfig)this.eurekaClientConfigBean, (ApplicationEventPublisher)this.context).with((EurekaClient)client).build();
            this.registrations.add(registration);
            try {
                this.serviceRegistry.register((Registration)registration);
                log.info((Object)("Successfully registered stub [" + entry.getKey().toColonSeparatedDependencyNotation() + "] in Service Discovery"));
            }
            catch (Exception e) {
                log.warn((Object)("Exception occurred while trying to register a stub [" + entry.getKey().toColonSeparatedDependencyNotation() + "] in Service Discovery"), (Throwable)e);
            }
        }
    }

    private AbstractDiscoveryClientOptionalArgs args() {
        try {
            return (AbstractDiscoveryClientOptionalArgs)this.context.getBean(AbstractDiscoveryClientOptionalArgs.class);
        }
        catch (BeansException e) {
            return null;
        }
    }

    private EurekaInstanceConfigBean registration(Map.Entry<StubConfiguration, Integer> entry) {
        EurekaInstanceConfigBean config = new EurekaInstanceConfigBean(this.inetUtils);
        String appName = this.name(entry.getKey());
        config.setInstanceEnabledOnit(true);
        InetAddress address = this.inetUtils.findFirstNonLoopbackAddress();
        config.setIpAddress(address.getHostAddress());
        config.setHostname(StringUtils.hasText((String)this.hostName(entry)) ? this.hostName(entry) : address.getHostName());
        config.setAppname(appName);
        config.setVirtualHostName(appName);
        config.setSecureVirtualHostName(appName);
        int port = this.port(entry);
        config.setNonSecurePort(port);
        config.setInstanceId(address.getHostAddress() + ":" + entry.getKey().getArtifactId() + ":" + port);
        config.setLeaseRenewalIntervalInSeconds(1);
        return config;
    }

    protected String hostName(Map.Entry<StubConfiguration, Integer> entry) {
        return this.eurekaInstanceConfigBean.getHostname();
    }

    protected int port(Map.Entry<StubConfiguration, Integer> entry) {
        return entry.getValue();
    }

    private String name(StubConfiguration stubConfiguration) {
        String resolvedName = this.stubMapperProperties.fromIvyNotationToId(stubConfiguration.toColonSeparatedDependencyNotation());
        if (StringUtils.hasText((String)resolvedName)) {
            return resolvedName;
        }
        return stubConfiguration.getArtifactId();
    }

    @Override
    public void close() throws Exception {
        for (EurekaRegistration registration : this.registrations) {
            this.serviceRegistry.deregister((Registration)registration);
        }
    }
}

