/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.environment;

import io.micrometer.observation.ObservationRegistry;
import java.io.File;
import java.lang.invoke.CallSite;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeanUtils;
import org.springframework.cloud.config.environment.Environment;
import org.springframework.cloud.config.server.environment.JGitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.JGitEnvironmentRepository;
import org.springframework.cloud.config.server.environment.MultipleJGitEnvironmentProperties;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

public class MultipleJGitEnvironmentRepository
extends JGitEnvironmentRepository {
    private Map<String, PatternMatchingJGitEnvironmentRepository> repos = new LinkedHashMap<String, PatternMatchingJGitEnvironmentRepository>();
    private Map<String, JGitEnvironmentRepository> placeholders = new LinkedHashMap<String, JGitEnvironmentRepository>();
    private final ObservationRegistry observationRegistry;

    public MultipleJGitEnvironmentRepository(ConfigurableEnvironment environment, MultipleJGitEnvironmentProperties properties, ObservationRegistry observationRegistry) {
        super(environment, properties, observationRegistry);
        this.observationRegistry = observationRegistry;
        properties.getRepos().forEach((name, props) -> this.repos.put((String)name, new PatternMatchingJGitEnvironmentRepository(environment, (MultipleJGitEnvironmentProperties.PatternMatchingJGitEnvironmentProperties)props, this.observationRegistry)));
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        super.afterPropertiesSet();
        for (String name : this.repos.keySet()) {
            PatternMatchingJGitEnvironmentRepository repo = this.repos.get(name);
            repo.setEnvironment(this.getEnvironment());
            if (!StringUtils.hasText((String)repo.getName())) {
                repo.setName(name);
            }
            if (repo.getPattern() == null || repo.getPattern().length == 0) {
                repo.setPattern(new String[]{name});
            }
            if (repo.getTransportConfigCallback() == null) {
                repo.setTransportConfigCallback(this.getTransportConfigCallback());
            }
            if (this.getTimeout() != 0 && repo.getTimeout() == 0) {
                repo.setTimeout(this.getTimeout());
            }
            if (this.getRefreshRate() != 0 && repo.getRefreshRate() == 0) {
                repo.setRefreshRate(this.getRefreshRate());
            }
            String user = repo.getUsername();
            String passphrase = repo.getPassphrase();
            if (user == null) {
                repo.setUsername(this.getUsername());
                repo.setPassword(this.getPassword());
            }
            if (passphrase == null) {
                repo.setPassphrase(this.getPassphrase());
            }
            if (this.isSkipSslValidation()) {
                repo.setSkipSslValidation(true);
            }
            repo.afterPropertiesSet();
        }
        if (!this.getBasedir().exists() && !this.getBasedir().mkdirs()) {
            throw new IllegalStateException("Basedir does not exist and can not be created: " + String.valueOf(this.getBasedir()));
        }
        if (!this.getBasedir().getParentFile().canWrite()) {
            throw new IllegalStateException("Cannot write parent of basedir (please configure a writable location): " + String.valueOf(this.getBasedir()));
        }
    }

    public Map<String, PatternMatchingJGitEnvironmentRepository> getRepos() {
        return this.repos;
    }

    public void setRepos(Map<String, PatternMatchingJGitEnvironmentRepository> repos) {
        this.repos.putAll(repos);
    }

    @Override
    public SearchPathLocator.Locations getLocations(String application, String profile, String label) {
        for (PatternMatchingJGitEnvironmentRepository repository : this.repos.values()) {
            if (!repository.matches(application, profile, label)) continue;
            for (JGitEnvironmentRepository candidate : this.getRepositories(repository, application, profile, label)) {
                try {
                    Environment source = candidate.findOne(application, profile, label, false);
                    if (source == null) continue;
                    return candidate.getLocations(application, profile, label);
                }
                catch (Exception e) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Cannot retrieve resource locations from " + candidate.getUri() + ", cause: (" + e.getClass().getSimpleName() + ") " + e.getMessage()), (Throwable)e);
                }
            }
        }
        JGitEnvironmentRepository candidate = this.getRepository(this, application, profile, label);
        if (candidate == this) {
            return super.getLocations(application, profile, label);
        }
        return candidate.getLocations(application, profile, label);
    }

    @Override
    public Environment findOne(String application, String profile, String label, boolean includeOrigin) {
        for (PatternMatchingJGitEnvironmentRepository repository : this.repos.values()) {
            if (!repository.matches(application, profile, label)) continue;
            for (JGitEnvironmentRepository candidate : this.getRepositories(repository, application, profile, label)) {
                try {
                    Environment source;
                    if (label == null) {
                        label = candidate.getDefaultLabel();
                    }
                    if ((source = candidate.findOne(application, profile, label, includeOrigin)) == null) continue;
                    return source;
                }
                catch (Exception e) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug((Object)("Cannot load configuration from " + candidate.getUri() + ", cause: (" + e.getClass().getSimpleName() + ") " + e.getMessage()), (Throwable)e);
                }
            }
        }
        JGitEnvironmentRepository candidate = this.getRepository(this, application, profile, label);
        if (label == null) {
            label = candidate.getDefaultLabel();
        }
        try {
            return this.findOneFromCandidate(candidate, application, profile, label, includeOrigin);
        }
        catch (Exception e) {
            if ("main".equals(label) && this.isTryMasterBranch()) {
                this.logger.info((Object)("Cannot find Environment with default label " + this.getDefaultLabel()), (Throwable)e);
                this.logger.info((Object)"Will try to find Environment master label instead.");
                candidate = this.getRepository(this, application, profile, "master");
                return this.findOneFromCandidate(candidate, application, profile, "master", includeOrigin);
            }
            throw e;
        }
    }

    private Environment findOneFromCandidate(JGitEnvironmentRepository candidate, String application, String profile, String label, boolean includeOrigin) {
        if (candidate == this) {
            return super.findOne(application, profile, label, includeOrigin);
        }
        return candidate.findOne(application, profile, label, includeOrigin);
    }

    private List<JGitEnvironmentRepository> getRepositories(JGitEnvironmentRepository repository, String application, String profile, String label) {
        String[] stringArray;
        ArrayList<JGitEnvironmentRepository> list = new ArrayList<JGitEnvironmentRepository>();
        if (profile == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = null;
        } else {
            stringArray = StringUtils.commaDelimitedListToStringArray((String)profile);
        }
        String[] profiles = stringArray;
        int i = profiles.length;
        while (i-- > 0) {
            list.add(this.getRepository(repository, application, profiles[i], label));
        }
        return list;
    }

    JGitEnvironmentRepository getRepository(JGitEnvironmentRepository repository, String application, String profile, String label) {
        if (!repository.getUri().contains("{")) {
            return repository;
        }
        String key = repository.getUri();
        if (key.contains("{label}") && label == null) {
            label = repository.getDefaultLabel();
        }
        if (application != null) {
            key = key.replace("{application}", application);
        }
        if (profile != null) {
            key = key.replace("{profile}", profile);
        }
        if (label != null) {
            key = key.replace("{label}", label);
        }
        if (!this.placeholders.containsKey(key)) {
            this.placeholders.put(key, this.getRepository(repository, key));
        }
        return this.placeholders.get(key);
    }

    private JGitEnvironmentRepository getRepository(JGitEnvironmentRepository source, String uri) {
        JGitEnvironmentRepository repository = new JGitEnvironmentRepository(null, new JGitEnvironmentProperties(), this.observationRegistry);
        File basedir = repository.getBasedir();
        BeanUtils.copyProperties((Object)source, (Object)repository);
        repository.setUri(uri);
        repository.setBasedir(new File(source.getBasedir(), basedir.getName()));
        return repository;
    }

    @Override
    public void setOrder(int order) {
        super.setOrder(order);
    }

    public static class PatternMatchingJGitEnvironmentRepository
    extends JGitEnvironmentRepository {
        private String[] pattern = new String[0];
        private String name;
        private final ObservationRegistry observationRegistry;

        public PatternMatchingJGitEnvironmentRepository(ObservationRegistry observationRegistry) {
            super(null, new JGitEnvironmentProperties(), observationRegistry);
            this.observationRegistry = observationRegistry;
        }

        public PatternMatchingJGitEnvironmentRepository(ConfigurableEnvironment environment, MultipleJGitEnvironmentProperties.PatternMatchingJGitEnvironmentProperties properties, ObservationRegistry observationRegistry) {
            super(environment, properties, observationRegistry);
            this.observationRegistry = observationRegistry;
            this.setPattern(properties.getPattern());
            this.name = properties.getName();
        }

        public boolean matches(String application, String profile, String label) {
            if (this.pattern == null || this.pattern.length == 0) {
                return false;
            }
            String[] profiles = StringUtils.commaDelimitedListToStringArray((String)profile);
            int i = profiles.length;
            while (i-- > 0) {
                if (!PatternMatchUtils.simpleMatch((String[])this.pattern, (String)(application + "/" + profiles[i]))) continue;
                return true;
            }
            return false;
        }

        @Override
        public Environment findOne(String application, String profile, String label, boolean includeOrigin) {
            if (this.pattern == null || this.pattern.length == 0) {
                return null;
            }
            if (PatternMatchUtils.simpleMatch((String[])this.pattern, (String)(application + "/" + profile))) {
                return super.findOne(application, profile, label, includeOrigin);
            }
            return null;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String[] getPattern() {
            return this.pattern;
        }

        public void setPattern(String[] pattern) {
            AbstractCollection patterns = new ArrayList<Object>();
            ArrayList<CallSite> otherProfiles = new ArrayList<CallSite>();
            for (String p : pattern) {
                if (p != null) {
                    if (!p.contains("/")) {
                        patterns.add(p + "/*");
                    }
                    if (!p.endsWith("*")) {
                        otherProfiles.add((CallSite)((Object)(p + ",*")));
                    }
                }
                patterns.add(p);
            }
            patterns.addAll(otherProfiles);
            if (!patterns.contains(null)) {
                patterns = new LinkedHashSet(patterns);
            }
            this.pattern = patterns.toArray(new String[0]);
        }
    }
}

