/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.retry;

import java.time.Duration;
import java.util.function.Function;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.core.retry.RetryPolicy;

public final class RetryPolicySettings {
    public static final long DEFAULT_MAX_ATTEMPTS = 3L;
    public static final Duration DEFAULT_DELAY = Duration.ofMillis(1000L);
    public static final double DEFAULT_MULTIPLIER = 1.0;
    public static final Duration DEFAULT_MAX_DELAY = Duration.ofMillis(Long.MAX_VALUE);
    private Long maxAttempts = 3L;
    private Duration delay = DEFAULT_DELAY;
    private @Nullable Duration jitter;
    private Double multiplier = 1.0;
    private Duration maxDelay = DEFAULT_MAX_DELAY;
    private @Nullable Function<// Could not load outer class - annotation placement on inner may be incorrect
    RetryPolicy.Builder, RetryPolicy> factory;

    public RetryPolicy createRetryPolicy() {
        PropertyMapper map = PropertyMapper.get();
        RetryPolicy.Builder builder = RetryPolicy.builder();
        map.from(this::getMaxAttempts).to(arg_0 -> ((RetryPolicy.Builder)builder).maxAttempts(arg_0));
        map.from(this::getDelay).to(arg_0 -> ((RetryPolicy.Builder)builder).delay(arg_0));
        map.from(this::getJitter).to(arg_0 -> ((RetryPolicy.Builder)builder).jitter(arg_0));
        map.from(this::getMultiplier).to(arg_0 -> ((RetryPolicy.Builder)builder).multiplier(arg_0));
        map.from(this::getMaxDelay).to(arg_0 -> ((RetryPolicy.Builder)builder).maxDelay(arg_0));
        return this.factory != null ? this.factory.apply(builder) : builder.build();
    }

    public Long getMaxAttempts() {
        return this.maxAttempts;
    }

    public void setMaxAttempts(Long maxAttempts) {
        this.maxAttempts = maxAttempts;
    }

    public Duration getDelay() {
        return this.delay;
    }

    public void setDelay(Duration delay) {
        this.delay = delay;
    }

    public @Nullable Duration getJitter() {
        return this.jitter;
    }

    public void setJitter(@Nullable Duration jitter) {
        this.jitter = jitter;
    }

    public Double getMultiplier() {
        return this.multiplier;
    }

    public void setMultiplier(Double multiplier) {
        this.multiplier = multiplier;
    }

    public Duration getMaxDelay() {
        return this.maxDelay;
    }

    public void setMaxDelay(Duration maxDelay) {
        this.maxDelay = maxDelay;
    }

    public void setFactory(@Nullable Function<// Could not load outer class - annotation placement on inner may be incorrect
    RetryPolicy.Builder, RetryPolicy> factory) {
        this.factory = factory;
    }
}

