/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.properties.source;

import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.context.properties.source.ConfigurationPropertySource;
import org.springframework.boot.origin.Origin;
import org.springframework.boot.origin.OriginProvider;
import org.springframework.boot.origin.OriginTrackedValue;
import org.springframework.core.style.ToStringCreator;
import org.springframework.lang.Contract;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class ConfigurationProperty
implements OriginProvider,
Comparable<ConfigurationProperty> {
    private final ConfigurationPropertyName name;
    private final Object value;
    private final @Nullable ConfigurationPropertySource source;
    private final @Nullable Origin origin;

    public ConfigurationProperty(ConfigurationPropertyName name, Object value, @Nullable Origin origin) {
        this(null, name, value, origin);
    }

    private ConfigurationProperty(@Nullable ConfigurationPropertySource source, ConfigurationPropertyName name, Object value, @Nullable Origin origin) {
        Assert.notNull((Object)name, (String)"'name' must not be null");
        Assert.notNull((Object)value, (String)"'value' must not be null");
        this.source = source;
        this.name = name;
        this.value = value;
        this.origin = origin;
    }

    public @Nullable ConfigurationPropertySource getSource() {
        return this.source;
    }

    public ConfigurationPropertyName getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public @Nullable Origin getOrigin() {
        return this.origin;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationProperty other = (ConfigurationProperty)obj;
        boolean result = true;
        result = result && ObjectUtils.nullSafeEquals((Object)this.name, (Object)other.name);
        result = result && ObjectUtils.nullSafeEquals((Object)this.value, (Object)other.value);
        return result;
    }

    public int hashCode() {
        int result = ObjectUtils.nullSafeHashCode((Object)this.name);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.value);
        return result;
    }

    public String toString() {
        return new ToStringCreator((Object)this).append("name", (Object)this.name).append("value", this.value).append("origin", (Object)this.origin).toString();
    }

    @Override
    public int compareTo(ConfigurationProperty other) {
        return this.name.compareTo(other.name);
    }

    @Contract(value="_, !null -> !null")
    static @Nullable ConfigurationProperty of(ConfigurationPropertyName name, @Nullable OriginTrackedValue value) {
        if (value == null) {
            return null;
        }
        return new ConfigurationProperty(name, value.getValue(), value.getOrigin());
    }

    @Contract(value="_, _, !null, _ -> !null")
    static @Nullable ConfigurationProperty of(@Nullable ConfigurationPropertySource source, ConfigurationPropertyName name, @Nullable Object value, @Nullable Origin origin) {
        if (value == null) {
            return null;
        }
        return new ConfigurationProperty(source, name, value, origin);
    }
}

