/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.webservices.autoconfigure.client;

import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.webservices.client.WebServiceMessageSenderFactory;
import org.springframework.boot.webservices.client.WebServiceTemplateBuilder;
import org.springframework.boot.webservices.client.WebServiceTemplateCustomizer;
import org.springframework.context.annotation.Bean;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.ws.client.core.WebServiceTemplate;

@AutoConfiguration
@ConditionalOnClass(value={WebServiceTemplate.class, Unmarshaller.class, Marshaller.class})
public final class WebServiceTemplateAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    WebServiceMessageSenderFactory webServiceHttpMessageSenderFactory(ObjectProvider<ClientHttpRequestFactoryBuilder<?>> clientHttpRequestFactoryBuilder, ObjectProvider<ClientHttpRequestFactorySettings> clientHttpRequestFactorySettings) {
        return WebServiceMessageSenderFactory.http((ClientHttpRequestFactoryBuilder)clientHttpRequestFactoryBuilder.getIfAvailable(ClientHttpRequestFactoryBuilder::detect), (ClientHttpRequestFactorySettings)clientHttpRequestFactorySettings.getIfAvailable());
    }

    @Bean
    @ConditionalOnMissingBean
    WebServiceTemplateBuilder webServiceTemplateBuilder(ObjectProvider<WebServiceMessageSenderFactory> httpWebServiceMessageSenderBuilder, ObjectProvider<WebServiceTemplateCustomizer> webServiceTemplateCustomizers) {
        List customizers;
        WebServiceTemplateBuilder templateBuilder = new WebServiceTemplateBuilder(new WebServiceTemplateCustomizer[0]);
        WebServiceMessageSenderFactory httpMessageSenderFactory = (WebServiceMessageSenderFactory)httpWebServiceMessageSenderBuilder.getIfAvailable();
        if (httpMessageSenderFactory != null) {
            templateBuilder = templateBuilder.httpMessageSenderFactory(httpMessageSenderFactory);
        }
        if (!(customizers = webServiceTemplateCustomizers.orderedStream().toList()).isEmpty()) {
            templateBuilder = templateBuilder.customizers(customizers);
        }
        return templateBuilder;
    }
}

