/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection;

import java.util.Objects;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.boot.origin.Origin;

class BeanOrigin
implements Origin {
    private final String beanName;
    private final @Nullable String resourceDescription;

    BeanOrigin(String beanName, @Nullable BeanDefinition beanDefinition) {
        this.beanName = beanName;
        this.resourceDescription = beanDefinition != null ? beanDefinition.getResourceDescription() : null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BeanOrigin other = (BeanOrigin)obj;
        return Objects.equals(this.beanName, other.beanName);
    }

    public int hashCode() {
        return this.beanName.hashCode();
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Bean '");
        result.append(this.beanName);
        result.append("'");
        if (this.resourceDescription != null) {
            result.append(" defined in ");
            result.append(this.resourceDescription);
        }
        return result.toString();
    }
}

