/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.testcontainers.service.connection.elasticsearch;

import java.util.List;
import org.springframework.boot.autoconfigure.elasticsearch.ElasticsearchConnectionDetails;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionDetailsFactory;
import org.springframework.boot.testcontainers.service.connection.ContainerConnectionSource;
import org.testcontainers.elasticsearch.ElasticsearchContainer;

class ElasticsearchContainerConnectionDetailsFactory
extends ContainerConnectionDetailsFactory<ElasticsearchContainer, ElasticsearchConnectionDetails> {
    private static final int DEFAULT_PORT = 9200;

    ElasticsearchContainerConnectionDetailsFactory() {
    }

    @Override
    protected ElasticsearchConnectionDetails getContainerConnectionDetails(ContainerConnectionSource<ElasticsearchContainer> source) {
        return new ElasticsearchContainerConnectionDetails(source);
    }

    private static final class ElasticsearchContainerConnectionDetails
    extends ContainerConnectionDetailsFactory.ContainerConnectionDetails<ElasticsearchContainer>
    implements ElasticsearchConnectionDetails {
        private ElasticsearchContainerConnectionDetails(ContainerConnectionSource<ElasticsearchContainer> source) {
            super(source);
        }

        public List<ElasticsearchConnectionDetails.Node> getNodes() {
            String host = ((ElasticsearchContainer)this.getContainer()).getHost();
            Integer port = ((ElasticsearchContainer)this.getContainer()).getMappedPort(9200);
            return List.of(new ElasticsearchConnectionDetails.Node(host, port.intValue(), ElasticsearchConnectionDetails.Node.Protocol.HTTP, null, null));
        }
    }
}

