/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.http.server;

import java.net.URI;
import java.util.Map;
import java.util.function.Supplier;
import org.jspecify.annotations.Nullable;
import org.springframework.util.function.SingletonSupplier;
import org.springframework.web.util.UriBuilder;
import org.springframework.web.util.UriBuilderFactory;

class LazyUriBuilderFactory
implements UriBuilderFactory {
    private final Supplier<UriBuilderFactory> supplier;

    LazyUriBuilderFactory(Supplier<UriBuilderFactory> supplier) {
        this.supplier = SingletonSupplier.of(supplier);
    }

    public URI expand(String uriTemplate, Map<String, ? extends @Nullable Object> uriVariables) {
        return this.delegate().expand(uriTemplate, uriVariables);
    }

    public URI expand(String uriTemplate, Object ... uriVariables) {
        return this.delegate().expand(uriTemplate, uriVariables);
    }

    public UriBuilder uriString(String uriTemplate) {
        return this.delegate().uriString(uriTemplate);
    }

    public UriBuilder builder() {
        return this.delegate().builder();
    }

    private UriBuilderFactory delegate() {
        return this.supplier.get();
    }
}

