/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.context.filter;

import java.io.IOException;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.context.TypeExcludeFilter;
import org.springframework.boot.test.context.TestComponent;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;

class TestTypeExcludeFilter
extends TypeExcludeFilter {
    private static final String BEAN_NAME = TestTypeExcludeFilter.class.getName();
    private static final String[] CLASS_ANNOTATIONS = new String[]{"org.junit.runner.RunWith", "org.junit.jupiter.api.extension.ExtendWith", "org.junit.platform.commons.annotation.Testable", "org.testng.annotations.Test"};
    private static final String[] METHOD_ANNOTATIONS = new String[]{"org.junit.Test", "org.junit.platform.commons.annotation.Testable", "org.testng.annotations.Test"};
    private static final TestTypeExcludeFilter INSTANCE = new TestTypeExcludeFilter();

    TestTypeExcludeFilter() {
    }

    public boolean match(MetadataReader metadataReader, MetadataReaderFactory metadataReaderFactory) throws IOException {
        if (this.isTestConfiguration(metadataReader)) {
            return true;
        }
        if (this.isTestClass(metadataReader)) {
            return true;
        }
        String enclosing = metadataReader.getClassMetadata().getEnclosingClassName();
        if (enclosing != null) {
            try {
                if (this.match(metadataReaderFactory.getMetadataReader(enclosing), metadataReaderFactory)) {
                    return true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean equals(@Nullable Object obj) {
        return obj != null && ((Object)((Object)this)).getClass() == obj.getClass();
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }

    private boolean isTestConfiguration(MetadataReader metadataReader) {
        return metadataReader.getAnnotationMetadata().isAnnotated(TestComponent.class.getName());
    }

    private boolean isTestClass(MetadataReader metadataReader) {
        for (String annotation : CLASS_ANNOTATIONS) {
            if (!metadataReader.getAnnotationMetadata().hasAnnotation(annotation)) continue;
            return true;
        }
        for (String annotation : METHOD_ANNOTATIONS) {
            if (!metadataReader.getAnnotationMetadata().hasAnnotatedMethods(annotation)) continue;
            return true;
        }
        return false;
    }

    static void registerWith(ConfigurableListableBeanFactory beanFactory) {
        if (!beanFactory.containsSingleton(BEAN_NAME)) {
            beanFactory.registerSingleton(BEAN_NAME, (Object)INSTANCE);
        }
    }
}

