/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.test.autoconfigure.web.servlet;

import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.htmlunit.BrowserVersion;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.test.autoconfigure.web.servlet.MockMvcAutoConfiguration;
import org.springframework.boot.web.server.test.htmlunit.webdriver.LocalHostWebConnectionHtmlUnitDriver;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.security.concurrent.DelegatingSecurityContextExecutor;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.htmlunit.webdriver.MockMvcHtmlUnitDriverBuilder;
import org.springframework.test.web.servlet.htmlunit.webdriver.WebConnectionHtmlUnitDriver;
import org.springframework.util.ClassUtils;

@AutoConfiguration(after={MockMvcAutoConfiguration.class})
@ConditionalOnClass(value={HtmlUnitDriver.class})
@ConditionalOnBooleanProperty(name={"spring.test.mockmvc.webdriver.enabled"}, matchIfMissing=true)
public final class MockMvcWebDriverAutoConfiguration {
    private static final String SECURITY_CONTEXT_EXECUTOR = "org.springframework.security.concurrent.DelegatingSecurityContextExecutor";

    @Bean
    @ConditionalOnMissingBean(value={WebDriver.class, MockMvcHtmlUnitDriverBuilder.class})
    @ConditionalOnBean(value={MockMvc.class})
    MockMvcHtmlUnitDriverBuilder mockMvcHtmlUnitDriverBuilder(MockMvc mockMvc, Environment environment) {
        return MockMvcHtmlUnitDriverBuilder.mockMvcSetup((MockMvc)mockMvc).withDelegate((WebConnectionHtmlUnitDriver)new LocalHostWebConnectionHtmlUnitDriver(environment, BrowserVersion.CHROME));
    }

    @Bean
    @ConditionalOnMissingBean(value={WebDriver.class})
    @ConditionalOnBean(value={MockMvcHtmlUnitDriverBuilder.class})
    HtmlUnitDriver htmlUnitDriver(MockMvcHtmlUnitDriverBuilder builder) {
        HtmlUnitDriver driver = builder.build();
        if (ClassUtils.isPresent((String)SECURITY_CONTEXT_EXECUTOR, (ClassLoader)this.getClass().getClassLoader())) {
            driver.setExecutor((Executor)new DelegatingSecurityContextExecutor((Executor)Executors.newSingleThreadExecutor()));
        }
        return driver;
    }
}

