/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.restclient.autoconfigure;

import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.ssl.SslAutoConfiguration;
import org.springframework.boot.autoconfigure.task.TaskExecutionAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.http.client.ClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.http.client.autoconfigure.HttpClientAutoConfiguration;
import org.springframework.boot.http.converter.autoconfigure.HttpMessageConverters;
import org.springframework.boot.restclient.RestClientCustomizer;
import org.springframework.boot.restclient.autoconfigure.AutoConfiguredRestClientSsl;
import org.springframework.boot.restclient.autoconfigure.HttpMessageConvertersRestClientCustomizer;
import org.springframework.boot.restclient.autoconfigure.NotReactiveWebApplicationOrVirtualThreadsExecutorEnabledCondition;
import org.springframework.boot.restclient.autoconfigure.PropertiesRestClientCustomizer;
import org.springframework.boot.restclient.autoconfigure.RestClientBuilderConfigurer;
import org.springframework.boot.restclient.autoconfigure.RestClientProperties;
import org.springframework.boot.restclient.autoconfigure.RestClientSsl;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Scope;
import org.springframework.core.annotation.Order;
import org.springframework.web.client.ApiVersionFormatter;
import org.springframework.web.client.ApiVersionInserter;
import org.springframework.web.client.RestClient;

@AutoConfiguration(after={HttpClientAutoConfiguration.class, TaskExecutionAutoConfiguration.class, SslAutoConfiguration.class})
@ConditionalOnClass(value={RestClient.class})
@Conditional(value={NotReactiveWebApplicationOrVirtualThreadsExecutorEnabledCondition.class})
@EnableConfigurationProperties(value={RestClientProperties.class})
public final class RestClientAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={RestClientSsl.class})
    @ConditionalOnBean(value={SslBundles.class})
    AutoConfiguredRestClientSsl restClientSsl(ObjectProvider<ClientHttpRequestFactoryBuilder<?>> clientHttpRequestFactoryBuilder, ObjectProvider<ClientHttpRequestFactorySettings> clientHttpRequestFactorySettings, SslBundles sslBundles) {
        return new AutoConfiguredRestClientSsl((ClientHttpRequestFactoryBuilder)clientHttpRequestFactoryBuilder.getIfAvailable(ClientHttpRequestFactoryBuilder::detect), (ClientHttpRequestFactorySettings)clientHttpRequestFactorySettings.getIfAvailable(ClientHttpRequestFactorySettings::defaults), sslBundles);
    }

    @Bean
    @ConditionalOnMissingBean
    RestClientBuilderConfigurer restClientBuilderConfigurer(ObjectProvider<ClientHttpRequestFactoryBuilder<?>> clientHttpRequestFactoryBuilder, ObjectProvider<ClientHttpRequestFactorySettings> clientHttpRequestFactorySettings, ObjectProvider<RestClientCustomizer> customizerProvider, ObjectProvider<ApiVersionInserter> apiVersionInserter, ObjectProvider<ApiVersionFormatter> apiVersionFormatter, RestClientProperties restClientProperties) {
        PropertiesRestClientCustomizer propertiesCustomizer = new PropertiesRestClientCustomizer((ApiVersionInserter)apiVersionInserter.getIfAvailable(), (ApiVersionFormatter)apiVersionFormatter.getIfAvailable(), restClientProperties);
        return new RestClientBuilderConfigurer((ClientHttpRequestFactoryBuilder)clientHttpRequestFactoryBuilder.getIfAvailable(ClientHttpRequestFactoryBuilder::detect), (ClientHttpRequestFactorySettings)clientHttpRequestFactorySettings.getIfAvailable(ClientHttpRequestFactorySettings::defaults), propertiesCustomizer, customizerProvider.orderedStream().toList());
    }

    @Bean
    @Scope(value="prototype")
    @ConditionalOnMissingBean
    RestClient.Builder restClientBuilder(RestClientBuilderConfigurer restClientBuilderConfigurer) {
        return restClientBuilderConfigurer.configure(RestClient.builder());
    }

    @ConditionalOnClass(value={HttpMessageConverters.class})
    static class HttpMessageConvertersConfiguration {
        HttpMessageConvertersConfiguration() {
        }

        @Bean
        @ConditionalOnMissingBean
        @Order(value=0x7FFFFFFF)
        HttpMessageConvertersRestClientCustomizer httpMessageConvertersRestClientCustomizer(ObjectProvider<HttpMessageConverters> messageConverters) {
            return new HttpMessageConvertersRestClientCustomizer((HttpMessageConverters)messageConverters.getIfUnique());
        }
    }
}

