/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.mongodb.autoconfigure;

import com.mongodb.ConnectionString;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.mongodb.autoconfigure.MongoConnectionDetails;
import org.springframework.boot.mongodb.autoconfigure.MongoProperties;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.boot.ssl.SslBundles;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PropertiesMongoConnectionDetails
implements MongoConnectionDetails {
    private final MongoProperties properties;
    private final @Nullable SslBundles sslBundles;

    public PropertiesMongoConnectionDetails(MongoProperties properties, @Nullable SslBundles sslBundles) {
        this.properties = properties;
        this.sslBundles = sslBundles;
    }

    @Override
    public ConnectionString getConnectionString() {
        if (this.properties.getUri() != null) {
            return new ConnectionString(this.properties.getUri());
        }
        StringBuilder builder = new StringBuilder(this.getProtocol()).append("://");
        if (this.properties.getUsername() != null) {
            builder.append(this.encode(this.properties.getUsername()));
            builder.append(":");
            if (this.properties.getPassword() != null) {
                builder.append(this.encode(this.properties.getPassword()));
            }
            builder.append("@");
        }
        builder.append(this.properties.getHost() != null ? this.properties.getHost() : "localhost");
        if (this.properties.getPort() != null) {
            builder.append(":");
            builder.append(this.properties.getPort());
        }
        if (this.properties.getAdditionalHosts() != null) {
            builder.append(",");
            builder.append(String.join((CharSequence)",", this.properties.getAdditionalHosts()));
        }
        builder.append("/");
        builder.append(this.properties.getMongoClientDatabase());
        List<String> options = this.getOptions();
        if (!options.isEmpty()) {
            builder.append("?");
            builder.append(String.join((CharSequence)"&", options));
        }
        return new ConnectionString(builder.toString());
    }

    private String getProtocol() {
        String protocol = this.properties.getProtocol();
        if (StringUtils.hasText((String)protocol)) {
            return protocol;
        }
        return "mongodb";
    }

    private String encode(String input) {
        return URLEncoder.encode(input, StandardCharsets.UTF_8);
    }

    private char[] encode(char[] input) {
        return URLEncoder.encode(new String(input), StandardCharsets.UTF_8).toCharArray();
    }

    @Override
    public @Nullable SslBundle getSslBundle() {
        MongoProperties.Ssl ssl = this.properties.getSsl();
        if (!ssl.isEnabled()) {
            return null;
        }
        if (StringUtils.hasLength((String)ssl.getBundle())) {
            Assert.notNull((Object)this.sslBundles, (String)"SSL bundle name has been set but no SSL bundles found in context");
            return this.sslBundles.getBundle(ssl.getBundle());
        }
        return SslBundle.systemDefault();
    }

    private List<String> getOptions() {
        ArrayList<String> options = new ArrayList<String>();
        if (StringUtils.hasText((String)this.properties.getReplicaSetName())) {
            options.add("replicaSet=" + this.properties.getReplicaSetName());
        }
        if (this.properties.getUsername() != null && this.properties.getAuthenticationDatabase() != null) {
            options.add("authSource=" + this.properties.getAuthenticationDatabase());
        }
        return options;
    }
}

