/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.metrics.autoconfigure.export.simple;

import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleConfig;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.micrometer.metrics.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.MetricsAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.ConditionalOnEnabledMetricsExport;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.simple.SimpleProperties;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.simple.SimplePropertiesConfigAdapter;
import org.springframework.context.annotation.Bean;

@AutoConfiguration(before={CompositeMeterRegistryAutoConfiguration.class}, after={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@EnableConfigurationProperties(value={SimpleProperties.class})
@ConditionalOnMissingBean(value={MeterRegistry.class})
@ConditionalOnEnabledMetricsExport(value="simple")
public final class SimpleMetricsExportAutoConfiguration {
    @Bean
    SimpleMeterRegistry simpleMeterRegistry(SimpleConfig config, Clock clock) {
        return new SimpleMeterRegistry(config, clock);
    }

    @Bean
    @ConditionalOnMissingBean
    SimpleConfig simpleConfig(SimpleProperties simpleProperties) {
        return new SimplePropertiesConfigAdapter(simpleProperties);
    }
}

