/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.micrometer.metrics.autoconfigure.export.otlp;

import io.micrometer.core.instrument.Clock;
import io.micrometer.registry.otlp.OtlpConfig;
import io.micrometer.registry.otlp.OtlpMeterRegistry;
import io.micrometer.registry.otlp.OtlpMetricsSender;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnThreading;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.micrometer.metrics.autoconfigure.CompositeMeterRegistryAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.MetricsAutoConfiguration;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.ConditionalOnEnabledMetricsExport;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.otlp.OtlpMetricsConnectionDetails;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.otlp.OtlpMetricsProperties;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.otlp.OtlpMetricsPropertiesConfigAdapter;
import org.springframework.boot.micrometer.metrics.autoconfigure.export.simple.SimpleMetricsExportAutoConfiguration;
import org.springframework.boot.opentelemetry.autoconfigure.OpenTelemetryProperties;
import org.springframework.boot.thread.Threading;
import org.springframework.context.annotation.Bean;
import org.springframework.core.env.Environment;
import org.springframework.core.task.VirtualThreadTaskExecutor;

@AutoConfiguration(before={CompositeMeterRegistryAutoConfiguration.class, SimpleMetricsExportAutoConfiguration.class}, after={MetricsAutoConfiguration.class})
@ConditionalOnBean(value={Clock.class})
@ConditionalOnClass(value={OtlpMeterRegistry.class, OpenTelemetryProperties.class})
@ConditionalOnEnabledMetricsExport(value="otlp")
@EnableConfigurationProperties(value={OtlpMetricsProperties.class, OpenTelemetryProperties.class})
public final class OtlpMetricsExportAutoConfiguration {
    private final OtlpMetricsProperties properties;

    OtlpMetricsExportAutoConfiguration(OtlpMetricsProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    OtlpMetricsConnectionDetails otlpMetricsConnectionDetails() {
        return new PropertiesOtlpMetricsConnectionDetails(this.properties);
    }

    @Bean
    @ConditionalOnMissingBean
    OtlpConfig otlpConfig(OpenTelemetryProperties openTelemetryProperties, OtlpMetricsConnectionDetails connectionDetails, Environment environment) {
        return new OtlpMetricsPropertiesConfigAdapter(this.properties, openTelemetryProperties, connectionDetails, environment);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnThreading(value=Threading.PLATFORM)
    OtlpMeterRegistry otlpMeterRegistry(OtlpConfig otlpConfig, Clock clock, ObjectProvider<OtlpMetricsSender> metricsSender) {
        return this.builder(otlpConfig, clock, metricsSender).build();
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnThreading(value=Threading.VIRTUAL)
    OtlpMeterRegistry otlpMeterRegistryVirtualThreads(OtlpConfig otlpConfig, Clock clock, ObjectProvider<OtlpMetricsSender> metricsSender) {
        VirtualThreadTaskExecutor executor = new VirtualThreadTaskExecutor("otlp-meter-registry-");
        return this.builder(otlpConfig, clock, metricsSender).threadFactory(executor.getVirtualThreadFactory()).build();
    }

    private OtlpMeterRegistry.Builder builder(OtlpConfig otlpConfig, Clock clock, ObjectProvider<OtlpMetricsSender> metricsSender) {
        OtlpMeterRegistry.Builder builder = OtlpMeterRegistry.builder((OtlpConfig)otlpConfig).clock(clock);
        metricsSender.ifAvailable(arg_0 -> ((OtlpMeterRegistry.Builder)builder).metricsSender(arg_0));
        return builder;
    }

    static class PropertiesOtlpMetricsConnectionDetails
    implements OtlpMetricsConnectionDetails {
        private final OtlpMetricsProperties properties;

        PropertiesOtlpMetricsConnectionDetails(OtlpMetricsProperties properties) {
            this.properties = properties;
        }

        @Override
        public @Nullable String getUrl() {
            return this.properties.getUrl();
        }
    }
}

