/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.http.client;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClientBuilder;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.core5.http.io.SocketConfig;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.http.client.AbstractClientHttpRequestFactoryBuilder;
import org.springframework.boot.http.client.ClientHttpRequestFactorySettings;
import org.springframework.boot.http.client.HttpComponentsHttpClientBuilder;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class HttpComponentsClientHttpRequestFactoryBuilder
extends AbstractClientHttpRequestFactoryBuilder<HttpComponentsClientHttpRequestFactory> {
    private final HttpComponentsHttpClientBuilder httpClientBuilder;

    HttpComponentsClientHttpRequestFactoryBuilder() {
        this(null, new HttpComponentsHttpClientBuilder());
    }

    private HttpComponentsClientHttpRequestFactoryBuilder(@Nullable List<Consumer<HttpComponentsClientHttpRequestFactory>> customizers, HttpComponentsHttpClientBuilder httpClientBuilder) {
        super(customizers);
        this.httpClientBuilder = httpClientBuilder;
    }

    public HttpComponentsClientHttpRequestFactoryBuilder withCustomizer(Consumer<HttpComponentsClientHttpRequestFactory> customizer) {
        return new HttpComponentsClientHttpRequestFactoryBuilder(this.mergedCustomizers(customizer), this.httpClientBuilder);
    }

    public HttpComponentsClientHttpRequestFactoryBuilder withCustomizers(Collection<Consumer<HttpComponentsClientHttpRequestFactory>> customizers) {
        return new HttpComponentsClientHttpRequestFactoryBuilder(this.mergedCustomizers(customizers), this.httpClientBuilder);
    }

    public HttpComponentsClientHttpRequestFactoryBuilder withHttpClientCustomizer(Consumer<HttpClientBuilder> httpClientCustomizer) {
        Assert.notNull(httpClientCustomizer, (String)"'httpClientCustomizer' must not be null");
        return new HttpComponentsClientHttpRequestFactoryBuilder(this.getCustomizers(), this.httpClientBuilder.withCustomizer(httpClientCustomizer));
    }

    public HttpComponentsClientHttpRequestFactoryBuilder withConnectionManagerCustomizer(Consumer<PoolingHttpClientConnectionManagerBuilder> connectionManagerCustomizer) {
        Assert.notNull(connectionManagerCustomizer, (String)"'connectionManagerCustomizer' must not be null");
        return new HttpComponentsClientHttpRequestFactoryBuilder(this.getCustomizers(), this.httpClientBuilder.withConnectionManagerCustomizer(connectionManagerCustomizer));
    }

    public HttpComponentsClientHttpRequestFactoryBuilder withSocketConfigCustomizer(Consumer<SocketConfig.Builder> socketConfigCustomizer) {
        Assert.notNull(socketConfigCustomizer, (String)"'socketConfigCustomizer' must not be null");
        return new HttpComponentsClientHttpRequestFactoryBuilder(this.getCustomizers(), this.httpClientBuilder.withSocketConfigCustomizer(socketConfigCustomizer));
    }

    public HttpComponentsClientHttpRequestFactoryBuilder withTlsSocketStrategyFactory(HttpComponentsHttpClientBuilder.TlsSocketStrategyFactory tlsSocketStrategyFactory) {
        Assert.notNull((Object)tlsSocketStrategyFactory, (String)"'tlsSocketStrategyFactory' must not be null");
        return new HttpComponentsClientHttpRequestFactoryBuilder(this.getCustomizers(), this.httpClientBuilder.withTlsSocketStrategyFactory(tlsSocketStrategyFactory));
    }

    public HttpComponentsClientHttpRequestFactoryBuilder withDefaultRequestConfigCustomizer(Consumer<RequestConfig.Builder> defaultRequestConfigCustomizer) {
        Assert.notNull(defaultRequestConfigCustomizer, (String)"'defaultRequestConfigCustomizer' must not be null");
        return new HttpComponentsClientHttpRequestFactoryBuilder(this.getCustomizers(), this.httpClientBuilder.withDefaultRequestConfigCustomizer(defaultRequestConfigCustomizer));
    }

    public HttpComponentsClientHttpRequestFactoryBuilder with(UnaryOperator<HttpComponentsClientHttpRequestFactoryBuilder> customizer) {
        return (HttpComponentsClientHttpRequestFactoryBuilder)customizer.apply(this);
    }

    @Override
    protected HttpComponentsClientHttpRequestFactory createClientHttpRequestFactory(ClientHttpRequestFactorySettings settings) {
        CloseableHttpClient httpClient = this.httpClientBuilder.build(this.asHttpClientSettings(settings.withConnectTimeout(null)));
        HttpComponentsClientHttpRequestFactory factory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        PropertyMapper map = PropertyMapper.get();
        map.from(settings::connectTimeout).asInt(Duration::toMillis).to(arg_0 -> ((HttpComponentsClientHttpRequestFactory)factory).setConnectTimeout(arg_0));
        return factory;
    }

    static class Classes {
        static final String HTTP_CLIENTS = "org.apache.hc.client5.http.impl.classic.HttpClients";

        Classes() {
        }

        static boolean present(@Nullable ClassLoader classLoader) {
            return ClassUtils.isPresent((String)HTTP_CLIENTS, (ClassLoader)classLoader);
        }
    }
}

