/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.health.registry;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.health.registry.HealthContributorNameValidator;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

abstract class AbstractRegistry<C, E> {
    private final Collection<HealthContributorNameValidator> nameValidators;
    private final BiFunction<String, C, E> entryAdapter;
    private volatile Map<String, C> contributors;
    private final Object monitor = new Object();

    AbstractRegistry(BiFunction<String, C, E> entryAdapter, @Nullable Collection<? extends HealthContributorNameValidator> nameValidators, @Nullable Consumer<BiConsumer<String, C>> initialRegistrations) {
        this.nameValidators = nameValidators != null ? List.copyOf(nameValidators) : Collections.emptyList();
        this.entryAdapter = entryAdapter;
        LinkedHashMap contributors = new LinkedHashMap();
        if (initialRegistrations != null) {
            initialRegistrations.accept((name, contributor) -> this.registerContributor(contributors, (String)name, (C)contributor));
        }
        this.contributors = Collections.unmodifiableMap(contributors);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerContributor(String name, C contributor) {
        Object object = this.monitor;
        synchronized (object) {
            LinkedHashMap<String, C> contributors = new LinkedHashMap<String, C>(this.contributors);
            this.registerContributor(contributors, name, contributor);
            this.contributors = Collections.unmodifiableMap(contributors);
        }
    }

    private void registerContributor(Map<String, C> contributors, String name, C contributor) {
        Assert.hasText((String)name, (String)"'name' must not be empty");
        Assert.notNull(contributor, (String)"'contributor' must not be null");
        this.verifyName(name, contributor);
        Assert.state((!contributors.containsKey(name) ? 1 : 0) != 0, () -> "A contributor named \"" + name + "\" has already been registered");
        contributors.put(name, contributor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable C unregisterContributor(String name) {
        Assert.notNull((Object)name, (String)"'name' must not be null");
        Object object = this.monitor;
        synchronized (object) {
            C unregistered = this.contributors.get(name);
            if (unregistered != null) {
                LinkedHashMap<String, C> contributors = new LinkedHashMap<String, C>(this.contributors);
                contributors.remove(name);
                this.contributors = Collections.unmodifiableMap(contributors);
            }
            return unregistered;
        }
    }

    @Nullable C getContributor(String name) {
        return this.contributors.get(name);
    }

    Stream<E> stream() {
        return this.contributors.entrySet().stream().map(entry -> this.entryAdapter.apply((String)entry.getKey(), entry.getValue()));
    }

    private void verifyName(String name, C contributor) {
        Assert.state((boolean)StringUtils.hasText((String)name), () -> "Name for contributor '%s' must not be empty".formatted(contributor));
        if (!CollectionUtils.isEmpty(this.nameValidators)) {
            this.nameValidators.forEach(nameValidator -> nameValidator.validate(name));
        }
    }
}

