/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.health.contributor;

import org.springframework.boot.health.contributor.Health;
import org.springframework.boot.health.contributor.HealthIndicator;
import org.springframework.boot.health.contributor.ReactiveHealthIndicator;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

class HealthIndicatorAdapter
implements ReactiveHealthIndicator {
    private final HealthIndicator delegate;

    HealthIndicatorAdapter(HealthIndicator delegate) {
        Assert.notNull((Object)delegate, (String)"'delegate' must not be null");
        this.delegate = delegate;
    }

    @Override
    public Mono<Health> health() {
        return Mono.fromCallable(this.delegate::health).subscribeOn(Schedulers.boundedElastic());
    }
}

