/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.flyway.actuate.endpoint;

import java.time.Instant;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationInfo;
import org.flywaydb.core.api.MigrationState;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.actuate.endpoint.OperationResponseBody;
import org.springframework.boot.actuate.endpoint.annotation.Endpoint;
import org.springframework.boot.actuate.endpoint.annotation.ReadOperation;
import org.springframework.context.ApplicationContext;

@Endpoint(id="flyway")
public class FlywayEndpoint {
    private final ApplicationContext context;

    public FlywayEndpoint(ApplicationContext context) {
        this.context = context;
    }

    @ReadOperation
    public FlywayBeansDescriptor flywayBeans() {
        ApplicationContext target = this.context;
        HashMap<@Nullable String, ContextFlywayBeansDescriptor> contextFlywayBeans = new HashMap<String, ContextFlywayBeansDescriptor>();
        while (target != null) {
            HashMap<String, FlywayDescriptor> flywayBeans = new HashMap<String, FlywayDescriptor>();
            target.getBeansOfType(Flyway.class).forEach((name, flyway) -> flywayBeans.put((String)name, new FlywayDescriptor(flyway.info().all())));
            ApplicationContext parent = target.getParent();
            contextFlywayBeans.put(target.getId(), new ContextFlywayBeansDescriptor(flywayBeans, parent != null ? parent.getId() : null));
            target = parent;
        }
        return new FlywayBeansDescriptor(contextFlywayBeans);
    }

    public static final class ContextFlywayBeansDescriptor {
        private final Map<String, FlywayDescriptor> flywayBeans;
        private final @Nullable String parentId;

        private ContextFlywayBeansDescriptor(Map<String, FlywayDescriptor> flywayBeans, @Nullable String parentId) {
            this.flywayBeans = flywayBeans;
            this.parentId = parentId;
        }

        public Map<String, FlywayDescriptor> getFlywayBeans() {
            return this.flywayBeans;
        }

        public @Nullable String getParentId() {
            return this.parentId;
        }
    }

    public static final class FlywayBeansDescriptor
    implements OperationResponseBody {
        private final Map<@Nullable String, ContextFlywayBeansDescriptor> contexts;

        private FlywayBeansDescriptor(Map<@Nullable String, ContextFlywayBeansDescriptor> contexts) {
            this.contexts = contexts;
        }

        public Map<@Nullable String, ContextFlywayBeansDescriptor> getContexts() {
            return this.contexts;
        }
    }

    public static class FlywayDescriptor {
        private final List<FlywayMigrationDescriptor> migrations;

        private FlywayDescriptor(MigrationInfo[] migrations) {
            this.migrations = Stream.of(migrations).map(FlywayMigrationDescriptor::new).toList();
        }

        public FlywayDescriptor(List<FlywayMigrationDescriptor> migrations) {
            this.migrations = migrations;
        }

        public List<FlywayMigrationDescriptor> getMigrations() {
            return this.migrations;
        }
    }

    public static final class FlywayMigrationDescriptor {
        private final String type;
        private final Integer checksum;
        private final @Nullable String version;
        private final String description;
        private final String script;
        private final MigrationState state;
        private final String installedBy;
        private final @Nullable Instant installedOn;
        private final Integer installedRank;
        private final Integer executionTime;

        private FlywayMigrationDescriptor(MigrationInfo info) {
            this.type = info.getType().name();
            this.checksum = info.getChecksum();
            this.version = this.nullSafeToString(info.getVersion());
            this.description = info.getDescription();
            this.script = info.getScript();
            this.state = info.getState();
            this.installedBy = info.getInstalledBy();
            this.installedRank = info.getInstalledRank();
            this.executionTime = info.getExecutionTime();
            this.installedOn = this.nullSafeToInstant(info.getInstalledOn());
        }

        private @Nullable String nullSafeToString(@Nullable Object obj) {
            return obj != null ? obj.toString() : null;
        }

        private @Nullable Instant nullSafeToInstant(@Nullable Date date) {
            return date != null ? Instant.ofEpochMilli(date.getTime()) : null;
        }

        public String getType() {
            return this.type;
        }

        public Integer getChecksum() {
            return this.checksum;
        }

        public @Nullable String getVersion() {
            return this.version;
        }

        public String getDescription() {
            return this.description;
        }

        public String getScript() {
            return this.script;
        }

        public MigrationState getState() {
            return this.state;
        }

        public String getInstalledBy() {
            return this.installedBy;
        }

        public @Nullable Instant getInstalledOn() {
            return this.installedOn;
        }

        public Integer getInstalledRank() {
            return this.installedRank;
        }

        public Integer getExecutionTime() {
            return this.executionTime;
        }
    }
}

