/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.core;

import java.util.regex.Matcher;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.docker.compose.core.ImageName;
import org.springframework.boot.docker.compose.core.Regex;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public final class ImageReference {
    private final ImageName name;
    private final @Nullable String tag;
    private final @Nullable String digest;
    private final String string;

    private ImageReference(ImageName name, @Nullable String tag, @Nullable String digest) {
        Assert.notNull((Object)name, (String)"'name' must not be null");
        this.name = name;
        this.tag = tag;
        this.digest = digest;
        this.string = this.buildString(name.toString(), tag, digest);
    }

    public String getDomain() {
        return this.name.getDomain();
    }

    public String getName() {
        return this.name.getName();
    }

    public @Nullable String getTag() {
        return this.tag;
    }

    public @Nullable String getDigest() {
        return this.digest;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ImageReference other = (ImageReference)obj;
        boolean result = true;
        result = result && this.name.equals(other.name);
        result = result && ObjectUtils.nullSafeEquals((Object)this.tag, (Object)other.tag);
        result = result && ObjectUtils.nullSafeEquals((Object)this.digest, (Object)other.digest);
        return result;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.name.hashCode();
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.tag);
        result = 31 * result + ObjectUtils.nullSafeHashCode((Object)this.digest);
        return result;
    }

    public String toString() {
        return this.string;
    }

    private String buildString(String name, @Nullable String tag, @Nullable String digest) {
        StringBuilder string = new StringBuilder(name);
        if (tag != null) {
            string.append(":").append(tag);
        }
        if (digest != null) {
            string.append("@").append(digest);
        }
        return string.toString();
    }

    public static ImageReference of(String value) {
        String remainder;
        Matcher matcher;
        String remainder2;
        Matcher matcher2;
        Assert.hasText((String)value, (String)"'value' must not be null");
        String domain = ImageName.parseDomain(value);
        Object path = domain != null ? value.substring(domain.length() + 1) : value;
        String digest = null;
        int digestSplit = ((String)path).indexOf("@");
        if (digestSplit != -1 && (matcher2 = Regex.DIGEST.matcher(remainder2 = ((String)path).substring(digestSplit + 1))).find()) {
            digest = remainder2.substring(0, matcher2.end());
            remainder2 = remainder2.substring(matcher2.end());
            path = ((String)path).substring(0, digestSplit) + remainder2;
        }
        String tag = null;
        int tagSplit = ((String)path).lastIndexOf(":");
        if (tagSplit != -1 && (matcher = Regex.TAG.matcher(remainder = ((String)path).substring(tagSplit + 1))).find()) {
            tag = remainder.substring(0, matcher.end());
            remainder = remainder.substring(matcher.end());
            path = ((String)path).substring(0, tagSplit) + remainder;
        }
        Assert.isTrue((boolean)Regex.PATH.matcher((CharSequence)path).matches(), () -> "'value' path must contain an image reference in the form '[domainHost:port/][path/]name[:tag][@digest] (with 'path' and 'name' containing only [a-z0-9][.][_][-]) [" + value + "]");
        ImageName name = new ImageName(domain, (String)path);
        return new ImageReference(name, tag, digest);
    }
}

