/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.docker.compose.service.connection.activemq;

import org.springframework.boot.autoconfigure.jms.activemq.ActiveMQConnectionDetails;
import org.springframework.boot.docker.compose.core.RunningService;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionDetailsFactory;
import org.springframework.boot.docker.compose.service.connection.DockerComposeConnectionSource;
import org.springframework.boot.docker.compose.service.connection.activemq.ActiveMQEnvironment;

class ActiveMQDockerComposeConnectionDetailsFactory
extends DockerComposeConnectionDetailsFactory<ActiveMQConnectionDetails> {
    private static final int ACTIVEMQ_PORT = 61616;

    protected ActiveMQDockerComposeConnectionDetailsFactory() {
        super("symptoma/activemq", new String[0]);
    }

    @Override
    protected ActiveMQConnectionDetails getDockerComposeConnectionDetails(DockerComposeConnectionSource source) {
        return new ActiveMQDockerComposeConnectionDetails(source.getRunningService());
    }

    static class ActiveMQDockerComposeConnectionDetails
    extends DockerComposeConnectionDetailsFactory.DockerComposeConnectionDetails
    implements ActiveMQConnectionDetails {
        private final ActiveMQEnvironment environment;
        private final String brokerUrl;

        protected ActiveMQDockerComposeConnectionDetails(RunningService service) {
            super(service);
            this.environment = new ActiveMQEnvironment(service.env());
            this.brokerUrl = "tcp://" + service.host() + ":" + service.ports().get(61616);
        }

        public String getBrokerUrl() {
            return this.brokerUrl;
        }

        public String getUser() {
            return this.environment.getUser();
        }

        public String getPassword() {
            return this.environment.getPassword();
        }
    }
}

