/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.data.redis.autoconfigure;

import java.util.ArrayList;
import java.util.List;
import org.jspecify.annotations.Nullable;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.data.redis.autoconfigure.RedisConnectionDetails;
import org.springframework.boot.data.redis.autoconfigure.RedisProperties;
import org.springframework.boot.data.redis.autoconfigure.RedisUrl;
import org.springframework.boot.ssl.SslBundle;
import org.springframework.data.redis.connection.RedisClusterConfiguration;
import org.springframework.data.redis.connection.RedisNode;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisSentinelConfiguration;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

abstract class RedisConnectionConfiguration {
    private static final boolean COMMONS_POOL2_AVAILABLE = ClassUtils.isPresent((String)"org.apache.commons.pool2.ObjectPool", (ClassLoader)RedisConnectionConfiguration.class.getClassLoader());
    private final RedisProperties properties;
    private final @Nullable RedisStandaloneConfiguration standaloneConfiguration;
    private final @Nullable RedisSentinelConfiguration sentinelConfiguration;
    private final @Nullable RedisClusterConfiguration clusterConfiguration;
    private final RedisConnectionDetails connectionDetails;
    protected final Mode mode;

    protected RedisConnectionConfiguration(RedisProperties properties, RedisConnectionDetails connectionDetails, ObjectProvider<RedisStandaloneConfiguration> standaloneConfigurationProvider, ObjectProvider<RedisSentinelConfiguration> sentinelConfigurationProvider, ObjectProvider<RedisClusterConfiguration> clusterConfigurationProvider) {
        this.properties = properties;
        this.standaloneConfiguration = (RedisStandaloneConfiguration)standaloneConfigurationProvider.getIfAvailable();
        this.sentinelConfiguration = (RedisSentinelConfiguration)sentinelConfigurationProvider.getIfAvailable();
        this.clusterConfiguration = (RedisClusterConfiguration)clusterConfigurationProvider.getIfAvailable();
        this.connectionDetails = connectionDetails;
        this.mode = this.determineMode();
    }

    protected final RedisStandaloneConfiguration getStandaloneConfig() {
        if (this.standaloneConfiguration != null) {
            return this.standaloneConfiguration;
        }
        RedisStandaloneConfiguration config = new RedisStandaloneConfiguration();
        RedisConnectionDetails.Standalone standalone = this.connectionDetails.getStandalone();
        Assert.state((standalone != null ? 1 : 0) != 0, (String)"'standalone' must not be null");
        config.setHostName(standalone.getHost());
        config.setPort(standalone.getPort());
        config.setUsername(this.connectionDetails.getUsername());
        config.setPassword(RedisPassword.of((String)this.connectionDetails.getPassword()));
        config.setDatabase(standalone.getDatabase());
        return config;
    }

    protected final @Nullable RedisSentinelConfiguration getSentinelConfig() {
        if (this.sentinelConfiguration != null) {
            return this.sentinelConfiguration;
        }
        if (this.connectionDetails.getSentinel() != null) {
            RedisSentinelConfiguration config = new RedisSentinelConfiguration();
            config.master(this.connectionDetails.getSentinel().getMaster());
            config.setSentinels(this.createSentinels(this.connectionDetails.getSentinel()));
            config.setUsername(this.connectionDetails.getUsername());
            String password = this.connectionDetails.getPassword();
            if (password != null) {
                config.setPassword(RedisPassword.of((String)password));
            }
            config.setSentinelUsername(this.connectionDetails.getSentinel().getUsername());
            String sentinelPassword = this.connectionDetails.getSentinel().getPassword();
            if (sentinelPassword != null) {
                config.setSentinelPassword(RedisPassword.of((String)sentinelPassword));
            }
            config.setDatabase(this.connectionDetails.getSentinel().getDatabase());
            return config;
        }
        return null;
    }

    protected final @Nullable RedisClusterConfiguration getClusterConfiguration() {
        if (this.clusterConfiguration != null) {
            return this.clusterConfiguration;
        }
        RedisProperties.Cluster clusterProperties = this.properties.getCluster();
        if (this.connectionDetails.getCluster() != null) {
            RedisClusterConfiguration config = new RedisClusterConfiguration();
            config.setClusterNodes(this.getNodes(this.connectionDetails.getCluster()));
            if (clusterProperties != null && clusterProperties.getMaxRedirects() != null) {
                config.setMaxRedirects(clusterProperties.getMaxRedirects().intValue());
            }
            config.setUsername(this.connectionDetails.getUsername());
            String password = this.connectionDetails.getPassword();
            if (password != null) {
                config.setPassword(RedisPassword.of((String)password));
            }
            return config;
        }
        return null;
    }

    private List<RedisNode> getNodes(RedisConnectionDetails.Cluster cluster) {
        return cluster.getNodes().stream().map(this::asRedisNode).toList();
    }

    private RedisNode asRedisNode(RedisConnectionDetails.Node node) {
        return new RedisNode(node.host(), node.port());
    }

    protected final RedisProperties getProperties() {
        return this.properties;
    }

    protected @Nullable SslBundle getSslBundle() {
        return switch (this.mode.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> {
                if (this.connectionDetails.getStandalone() != null) {
                    yield this.connectionDetails.getStandalone().getSslBundle();
                }
                yield null;
            }
            case 1 -> {
                if (this.connectionDetails.getCluster() != null) {
                    yield this.connectionDetails.getCluster().getSslBundle();
                }
                yield null;
            }
            case 2 -> this.connectionDetails.getSentinel() != null ? this.connectionDetails.getSentinel().getSslBundle() : null;
        };
    }

    protected final boolean isSslEnabled() {
        return this.getProperties().getSsl().isEnabled();
    }

    protected final boolean urlUsesSsl(String url) {
        return RedisUrl.of(url).useSsl();
    }

    protected boolean isPoolEnabled(RedisProperties.Pool pool) {
        Boolean enabled = pool.getEnabled();
        return enabled != null ? enabled : COMMONS_POOL2_AVAILABLE;
    }

    private List<RedisNode> createSentinels(RedisConnectionDetails.Sentinel sentinel) {
        ArrayList<RedisNode> nodes = new ArrayList<RedisNode>();
        for (RedisConnectionDetails.Node node : sentinel.getNodes()) {
            nodes.add(this.asRedisNode(node));
        }
        return nodes;
    }

    protected final RedisConnectionDetails getConnectionDetails() {
        return this.connectionDetails;
    }

    private Mode determineMode() {
        if (this.getSentinelConfig() != null) {
            return Mode.SENTINEL;
        }
        if (this.getClusterConfiguration() != null) {
            return Mode.CLUSTER;
        }
        return Mode.STANDALONE;
    }

    static enum Mode {
        STANDALONE,
        CLUSTER,
        SENTINEL;

    }
}

